# this script generates visualizer header
import os

visualizer_dir = 'extension/visualizer'
visualizer_css = os.path.join(visualizer_dir, 'visualizer.css')
visualizer_d3 = os.path.join(visualizer_dir, 'd3.js')
visualizer_script = os.path.join(visualizer_dir, 'script.js')
visualizer_header = os.path.join(visualizer_dir, 'include', 'visualizer_constants.hpp')


def open_utf8(fpath, flags):
    import sys

    if sys.version_info[0] < 3:
        return open(fpath, flags)
    else:
        return open(fpath, flags, encoding="utf8")


def get_byte_array(fpath, add_null_terminator=True):
    with open(fpath, 'rb') as f:
        text = bytearray(f.read())
    result_text = ""
    first = True
    for byte in text:
        if first:
            result_text += str(byte)
        else:
            result_text += ", " + str(byte)
        first = False
    if add_null_terminator:
        result_text += ", 0"
    return result_text


def write_file(fname, varname):
    result = "const uint8_t %s[] = {" % (varname,) + get_byte_array(fname) + "};\n"
    return result


def create_visualizer_header():
    result = """/* THIS FILE WAS AUTOMATICALLY GENERATED BY generate_visualizer_header.py */
    
/*
Copyright 2010-2020 Mike Bostock
All rights reserved.

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.

* Redistributions in binary form must reproduce the above copyright notice,
  this list of conditions and the following disclaimer in the documentation
  and/or other materials provided with the distribution.

* Neither the name of the author nor the names of contributors may be used to
  endorse or promote products derived from this software without specific prior
  written permission.

THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR
ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON
ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
*/

#pragma once

"""

    result += write_file(visualizer_css, "css")
    result += write_file(visualizer_d3, "d3")
    result += write_file(visualizer_script, "script")

    with open_utf8(visualizer_header, 'w+') as f:
        f.write(result)


create_visualizer_header()
