% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Driver.R
\docType{class}
\name{duckdb_driver}
\alias{duckdb_driver}
\alias{duckdb}
\alias{duckdb_driver-class}
\alias{show,duckdb_driver-method}
\alias{dbConnect,duckdb_driver-method}
\alias{dbDataType,duckdb_driver-method}
\alias{dbIsValid,duckdb_driver-method}
\alias{dbGetInfo,duckdb_driver-method}
\alias{duckdb_shutdown}
\alias{src_duckdb}
\title{DuckDB Driver}
\usage{
duckdb(dbdir = DBDIR_MEMORY, read_only = FALSE)

\S4method{show}{duckdb_driver}(object)

\S4method{dbConnect}{duckdb_driver}(
  drv,
  dbdir = DBDIR_MEMORY,
  ...,
  debug = getOption("duckdb.debug", FALSE),
  read_only = FALSE
)

\S4method{dbDataType}{duckdb_driver}(dbObj, obj, ...)

\S4method{dbIsValid}{duckdb_driver}(dbObj, ...)

\S4method{dbGetInfo}{duckdb_driver}(dbObj, ...)

duckdb_shutdown(drv)

src_duckdb(path = ":memory:", create = FALSE, read_only = FALSE)
}
\arguments{
\item{dbdir}{The file in which the DuckDB database should be stored}

\item{read_only}{Whether the database file should be opened in read-only mode}

\item{object}{Any R object}

\item{drv}{an object that inherits from \linkS4class{DBIDriver},
or an existing \linkS4class{DBIConnection}
object (in order to clone an existing connection).}

\item{...}{authentication arguments needed by the DBMS instance; these
typically include \code{user}, \code{password}, \code{host}, \code{port}, \code{dbname}, etc.
For details see the appropriate \code{DBIDriver}.}

\item{debug}{Print additional debug information such as queries}

\item{dbObj}{A object inheriting from \linkS4class{DBIDriver}
or \linkS4class{DBIConnection}}

\item{obj}{An R object whose SQL type we want to determine.}

\item{path}{The file in which the DuckDB database should be stored}

\item{create}{Create a new database if none is present in `path`}
}
\description{
A DuckDB database instance.
}
\examples{
\dontrun{
#' library(DBI)
duckdb::duckdb()
}

}
