/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.crypto;

import com.joyent.manta.client.MantaMetadata;
import com.joyent.manta.exception.MantaClientEncryptionException;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections4.map.CaseInsensitiveMap;
import org.apache.commons.lang3.CharUtils;

public final class EncryptedMetadataUtils {
    private EncryptedMetadataUtils() {
    }

    public static String encryptedMetadataAsString(MantaMetadata metadata) {
        Set<Map.Entry<String, String>> entrySet = metadata.entrySet();
        Iterator<Map.Entry<String, String>> iterator = entrySet.iterator();
        StringBuilder builder = new StringBuilder();
        while (iterator.hasNext()) {
            Map.Entry<String, String> entry = iterator.next();
            if (!entry.getKey().startsWith("e-")) continue;
            String line = String.format("%s: %s", entry.getKey(), entry.getValue());
            builder.append(line);
            if (!iterator.hasNext()) continue;
            builder.append('\n');
        }
        return builder.toString();
    }

    public static Map<String, String> plaintextMetadataAsMap(String plaintext) {
        return EncryptedMetadataUtils.plaintextMetadataAsMap(plaintext.getBytes(StandardCharsets.US_ASCII));
    }

    public static Map<String, String> plaintextMetadataAsMap(byte[] plaintext) {
        CaseInsensitiveMap map = new CaseInsensitiveMap();
        boolean parsingKey = true;
        boolean parsingVal = false;
        int initialSize = 24;
        StringBuilder key = new StringBuilder(24);
        StringBuilder val = new StringBuilder(24);
        for (int i = 0; i <= plaintext.length; ++i) {
            if (i == plaintext.length || (char)plaintext[i] == '\n') {
                if (key.length() > 0) {
                    map.put(key.toString(), val.toString());
                }
                key.setLength(0);
                val.setLength(0);
                parsingKey = true;
                parsingVal = false;
                continue;
            }
            char c = (char)plaintext[i];
            if (!CharUtils.isAsciiPrintable((char)c)) {
                String msg = "Encrypted metadata contained a non-ascii or unprintable character";
                throw new MantaClientEncryptionException(msg);
            }
            if (c == ':' && parsingKey) {
                parsingKey = false;
                continue;
            }
            if (c == ' ' && !parsingKey && !parsingVal) continue;
            if (!parsingKey && !parsingVal) {
                parsingVal = true;
            }
            if (parsingKey) {
                key.append(c);
            }
            if (!parsingVal) continue;
            val.append(c);
        }
        return map;
    }
}

