/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractPaginationRequest;
import com.spectralogic.ds3client.models.BucketAclPermission;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class GetBucketAclsSpectraS3Request
extends AbstractPaginationRequest {
    private String bucketId;
    private String groupId;
    private boolean lastPage;
    private int pageLength;
    private int pageOffset;
    private String pageStartMarker;
    private BucketAclPermission permission;
    private String userId;

    public GetBucketAclsSpectraS3Request withBucketId(String bucketId) {
        this.bucketId = bucketId;
        this.updateQueryParam("bucket_id", bucketId);
        return this;
    }

    public GetBucketAclsSpectraS3Request withGroupId(UUID groupId) {
        this.groupId = groupId.toString();
        this.updateQueryParam("group_id", groupId);
        return this;
    }

    public GetBucketAclsSpectraS3Request withGroupId(String groupId) {
        this.groupId = groupId;
        this.updateQueryParam("group_id", groupId);
        return this;
    }

    public GetBucketAclsSpectraS3Request withLastPage(boolean lastPage) {
        this.lastPage = lastPage;
        if (this.lastPage) {
            this.getQueryParams().put("last_page", null);
        } else {
            this.getQueryParams().remove("last_page");
        }
        return this;
    }

    public GetBucketAclsSpectraS3Request withPageLength(int pageLength) {
        this.pageLength = pageLength;
        this.updateQueryParam("page_length", pageLength);
        return this;
    }

    public GetBucketAclsSpectraS3Request withPageOffset(int pageOffset) {
        this.pageOffset = pageOffset;
        this.updateQueryParam("page_offset", pageOffset);
        return this;
    }

    public GetBucketAclsSpectraS3Request withPageStartMarker(UUID pageStartMarker) {
        this.pageStartMarker = pageStartMarker.toString();
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetBucketAclsSpectraS3Request withPageStartMarker(String pageStartMarker) {
        this.pageStartMarker = pageStartMarker;
        this.updateQueryParam("page_start_marker", pageStartMarker);
        return this;
    }

    public GetBucketAclsSpectraS3Request withPermission(BucketAclPermission permission) {
        this.permission = permission;
        this.updateQueryParam("permission", permission);
        return this;
    }

    public GetBucketAclsSpectraS3Request withUserId(UUID userId) {
        this.userId = userId.toString();
        this.updateQueryParam("user_id", userId);
        return this;
    }

    public GetBucketAclsSpectraS3Request withUserId(String userId) {
        this.userId = userId;
        this.updateQueryParam("user_id", userId);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.GET;
    }

    @Override
    public String getPath() {
        return "/_rest_/bucket_acl";
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public boolean getLastPage() {
        return this.lastPage;
    }

    public int getPageLength() {
        return this.pageLength;
    }

    public int getPageOffset() {
        return this.pageOffset;
    }

    public String getPageStartMarker() {
        return this.pageStartMarker;
    }

    public BucketAclPermission getPermission() {
        return this.permission;
    }

    public String getUserId() {
        return this.userId;
    }
}

