/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class HeadObjectRequest
extends AbstractRequest {
    private final String bucketName;
    private final String objectName;
    private String versionId;

    public HeadObjectRequest(String bucketName, String objectName) {
        this.bucketName = bucketName;
        this.objectName = objectName;
    }

    public HeadObjectRequest withVersionId(UUID versionId) {
        this.versionId = versionId.toString();
        this.updateQueryParam("version_id", versionId);
        return this;
    }

    public HeadObjectRequest withVersionId(String versionId) {
        this.versionId = versionId;
        this.updateQueryParam("version_id", versionId);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.HEAD;
    }

    @Override
    public String getPath() {
        return "/" + this.bucketName + "/" + this.objectName;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public String getVersionId() {
        return this.versionId;
    }
}

