/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.onedrive.AbstractSharepointSession;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.SharepointListService;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import java.util.Deque;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.types.GroupItem;
import org.nuxeo.onedrive.client.types.Site;

public class SharepointSession
extends AbstractSharepointSession {
    private static final Logger log = Logger.getLogger(SharepointSession.class);

    public SharepointSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    @Override
    public boolean isSingleSite() {
        return false;
    }

    @Override
    public Site getSite(Path file) throws BackgroundException {
        return Site.byId((OneDriveAPI)((OneDriveAPI)this.getClient()), (String)this.fileIdProvider.getFileid(file, (ListProgressListener)new DisabledListProgressListener()));
    }

    @Override
    public GroupItem getGroup(Path file) throws BackgroundException {
        return new GroupItem((OneDriveAPI)this.getClient(), this.fileIdProvider.getFileid(file, (ListProgressListener)new DisabledListProgressListener()));
    }

    @Override
    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new SharepointListService(this, (IdProvider)this.getFeature(IdProvider.class));
        }
        return super._getFeature(type);
    }

    @Override
    public GraphSession.ContainerItem getContainer(Path file) {
        Deque<Path> pathDeque = this.decompose(file);
        Path lastContainer = null;
        Path lastCollection = null;
        boolean exit = false;
        boolean nextExit = false;
        boolean exitEarly = false;
        block10: while (!exit && pathDeque.size() > 0) {
            Path current = pathDeque.pop();
            exit = nextExit;
            nextExit = exitEarly;
            switch (current.getName()) {
                case "Drives": {
                    nextExit = true;
                }
                case "Sites": {
                    lastCollection = current;
                    continue block10;
                }
                case "Groups": {
                    lastCollection = current;
                    exitEarly = true;
                    continue block10;
                }
            }
            lastContainer = current;
        }
        return new GraphSession.ContainerItem(lastContainer, lastCollection, exit);
    }
}

