/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public abstract class AbstractListService<T>
implements ListService {
    private static final Logger log = Logger.getLogger(AbstractListService.class);

    public final AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        AttributedList children = new AttributedList();
        Iterator<T> iterator = this.getIterator(directory);
        boolean filtering = this.isFiltering(directory);
        try {
            this.iterate((AttributedList<Path>)children, iterator, directory, filtering);
        }
        catch (OneDriveRuntimeException e) {
            throw new GraphExceptionMappingService().map("Listing directory {0} failed", (Throwable)e.getCause(), directory);
        }
        this.postList((AttributedList<Path>)children);
        listener.chunk(directory, children);
        return children;
    }

    protected final void iterate(AttributedList<Path> children, Iterator<T> iterator, Path directory, boolean filtering) {
        while (iterator.hasNext()) {
            T metadata;
            try {
                metadata = iterator.next();
            }
            catch (Exception e) {
                log.warn((Object)e.getMessage());
                continue;
            }
            if (filtering && !this.filter(metadata)) continue;
            children.add((Referenceable)this.toPath(metadata, directory));
        }
    }

    protected abstract Iterator<T> getIterator(Path var1) throws BackgroundException;

    protected abstract Path toPath(T var1, Path var2);

    protected boolean isFiltering(Path directory) {
        return false;
    }

    protected boolean filter(T metadata) {
        return true;
    }

    protected void postList(AttributedList<Path> list) {
    }
}

