/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.ChecksumCompute;
import ch.cyberduck.core.io.StatusOutputStream;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.vault.VaultRegistry;
import ch.cyberduck.core.vault.VaultUnlockCancelException;

public class VaultRegistryWriteFeature<T>
implements Write<T> {
    private final Session<?> session;
    private final Write proxy;
    private final VaultRegistry registry;

    public VaultRegistryWriteFeature(Session<?> session, Write proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public StatusOutputStream<T> write(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Write.class, this.proxy).write(file, status, callback);
    }

    @Override
    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Write.class, this.proxy).append(file, length, cache);
    }

    @Override
    public boolean temporary() {
        return this.proxy.temporary();
    }

    @Override
    public boolean random() {
        return this.proxy.random();
    }

    @Override
    public ChecksumCompute checksum(Path file, TransferStatus status) {
        try {
            return this.registry.find(this.session, file).getFeature(this.session, Write.class, this.proxy).checksum(file, status);
        }
        catch (VaultUnlockCancelException e) {
            return this.proxy.checksum(file, status);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryWriteFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

