/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers.strategy.transferstrategy;

import com.google.common.base.Preconditions;
import com.spectralogic.ds3client.helpers.ExceptionClassifier;
import com.spectralogic.ds3client.helpers.JobPart;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferMethod;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferRetryDecorator;
import java.io.IOException;

public class MaxNumObjectTransferAttemptsDecorator
implements TransferRetryDecorator {
    private final int maxNumObjectTransferAttempts;
    private TransferMethod transferMethodDelegate;

    public MaxNumObjectTransferAttemptsDecorator(int maxNumObjectTransferAttempts) {
        this.maxNumObjectTransferAttempts = maxNumObjectTransferAttempts;
    }

    @Override
    public TransferMethod wrap(TransferMethod transferMethod) {
        Preconditions.checkNotNull((Object)transferMethod, (Object)"transferMethod may not be null.");
        this.transferMethodDelegate = transferMethod;
        return this;
    }

    @Override
    public void transferJobPart(JobPart jobPart) throws IOException {
        int objectTransfersAttempted = 0;
        while (true) {
            try {
                this.transferMethodDelegate.transferJobPart(jobPart);
            }
            catch (Throwable t) {
                if (!ExceptionClassifier.isUnrecoverableException(t) && ++objectTransfersAttempted < this.maxNumObjectTransferAttempts) continue;
                throw t;
            }
            break;
        }
    }
}

