/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.parsers;

import com.spectralogic.ds3client.commands.parsers.interfaces.AbstractResponseParser;
import com.spectralogic.ds3client.commands.parsers.utils.ResponseParserUtils;
import com.spectralogic.ds3client.commands.spectrads3.GetBlobPersistenceSpectraS3Response;
import com.spectralogic.ds3client.networking.WebResponse;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import org.apache.commons.io.IOUtils;

public class GetBlobPersistenceSpectraS3ResponseParser
extends AbstractResponseParser<GetBlobPersistenceSpectraS3Response> {
    private final int[] expectedStatusCodes = new int[]{200};

    @Override
    public GetBlobPersistenceSpectraS3Response parseXmlResponse(WebResponse response) throws IOException {
        int statusCode = response.getStatusCode();
        if (ResponseParserUtils.validateStatusCode(statusCode, this.expectedStatusCodes)) {
            switch (statusCode) {
                case 200: {
                    try (InputStream inputStream = response.getResponseStream();){
                        String result = IOUtils.toString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
                        GetBlobPersistenceSpectraS3Response getBlobPersistenceSpectraS3Response = new GetBlobPersistenceSpectraS3Response(result, this.getChecksum(), this.getChecksumType());
                        return getBlobPersistenceSpectraS3Response;
                    }
                }
            }
            assert (false) : "validateStatusCode should have made it impossible to reach this line";
        }
        throw ResponseParserUtils.createFailedRequest(response, this.expectedStatusCodes);
    }
}

