/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.BookmarkCollection;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DisabledCancelCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.http.DisabledServiceUnavailableRetryStrategy;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.proxy.ProxyHostUrlProvider;
import ch.cyberduck.core.threading.CancelCallback;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class BrickUnauthorizedRetryStrategy
extends DisabledServiceUnavailableRetryStrategy {
    private static final Logger log = Logger.getLogger(BrickUnauthorizedRetryStrategy.class);
    private static final int MAX_RETRIES = 1;
    private final HostPasswordStore store = PasswordStoreFactory.get();
    private final BrickSession session;
    private final LoginCallback prompt;

    public BrickUnauthorizedRetryStrategy(BrickSession session, LoginCallback prompt) {
        this.session = session;
        this.prompt = prompt;
    }

    public boolean retryRequest(HttpResponse response, int executionCount, HttpContext context) {
        switch (response.getStatusLine().getStatusCode()) {
            case 401: {
                if (executionCount > 1) break;
                try {
                    BookmarkCollection bookmarks;
                    Host bookmark = this.session.getHost();
                    Credentials credentials = bookmark.getCredentials();
                    credentials.reset();
                    this.session.login(ProxyFactory.get().find(new ProxyHostUrlProvider().get(bookmark)), this.prompt, (CancelCallback)new DisabledCancelCallback());
                    if (credentials.isSaved()) {
                        this.store.save(bookmark);
                    }
                    if ((bookmarks = BookmarkCollection.defaultCollection()).isLoaded() && bookmarks.contains((Object)bookmark)) {
                        bookmarks.collectionItemChanged((Object)bookmark);
                    }
                    credentials.reset();
                    return true;
                }
                catch (BackgroundException e) {
                    log.warn((Object)String.format("Failure %s trying to refresh pairing after error response %s", new Object[]{e, response}));
                }
            }
        }
        return false;
    }
}

