/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledLoginCallback;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordStoreFactory;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.brick.BrickSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Pairing;
import ch.cyberduck.core.http.DefaultHttpResponseExceptionMappingService;
import ch.cyberduck.core.http.HttpConnectionPoolBuilder;
import ch.cyberduck.core.proxy.ProxyFactory;
import ch.cyberduck.core.proxy.ProxyHostUrlProvider;
import java.io.IOException;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpResponseException;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Lookup;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;

public class BrickPairingFeature
implements Pairing {
    private static final Logger log = Logger.getLogger(BrickPairingFeature.class);
    private final BrickSession session;
    private final HttpConnectionPoolBuilder builder;

    public BrickPairingFeature(BrickSession session, HttpConnectionPoolBuilder builder) {
        this.session = session;
        this.builder = builder;
    }

    public void delete(String token) throws BackgroundException {
        try {
            HttpClientBuilder configuration = this.builder.build(ProxyFactory.get().find(new ProxyHostUrlProvider().get(this.session.getHost())), (TranscriptListener)this.session, (LoginCallback)new DisabledLoginCallback());
            configuration.setDefaultAuthSchemeRegistry((Lookup)RegistryBuilder.create().build());
            CloseableHttpClient client = configuration.build();
            HttpDelete resource = new HttpDelete(String.format("%s/api/rest/v1/api_key", new HostUrlProvider().withUsername(false).withPath(false).get(this.session.getHost())));
            resource.setHeader("X-FilesAPI-Key", token);
            resource.setHeader("Accept", "application/json");
            resource.setHeader("Content-Type", "application/json");
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Delete paring key %s", token));
            }
            client.execute((HttpUriRequest)resource, (ResponseHandler)new ResponseHandler<Void>(){

                public Void handleResponse(HttpResponse response) throws ClientProtocolException, IOException {
                    return null;
                }
            });
            client.close();
        }
        catch (HttpResponseException e) {
            throw new DefaultHttpResponseExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        finally {
            PasswordStoreFactory.get().delete(this.session.getHost());
        }
    }
}

