/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.download;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.io.DelegateStreamListener;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.local.IconService;
import ch.cyberduck.core.local.IconServiceFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import java.math.BigDecimal;
import java.math.RoundingMode;

public class IconUpdateSreamListener
extends DelegateStreamListener {
    private final TransferStatus status;
    private final Local file;
    private final IconService icon = IconServiceFactory.get();
    private int step = 0;
    private final boolean threshold;

    public IconUpdateSreamListener(StreamListener delegate, TransferStatus status, Local file) {
        super(delegate);
        this.status = status;
        Preferences preferences = PreferencesFactory.get();
        this.threshold = status.getLength() > preferences.getLong("queue.download.icon.threshold");
        this.file = file;
    }

    @Override
    public void recv(long bytes) {
        BigDecimal fraction;
        if (this.threshold && (fraction = new BigDecimal(this.status.getOffset()).divide(new BigDecimal(this.status.getLength()), 1, RoundingMode.DOWN)).multiply(BigDecimal.TEN).intValue() > this.step) {
            this.icon.set(this.file, this.status);
            ++this.step;
        }
        super.recv(bytes);
    }
}

