/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CaseInsensitivePathPredicate;
import ch.cyberduck.core.DefaultPathPredicate;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.IndexedListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ListCanceledException;
import org.apache.commons.lang3.StringUtils;

public abstract class ListFilteringFeature {
    private final Session<?> session;
    private Cache<Path> cache = PathCache.empty();

    public ListFilteringFeature(Session<?> session) {
        this.session = session;
    }

    protected Path search(final Path file) throws BackgroundException {
        AttributedList<Path> list;
        if (!this.cache.isCached(file.getParent())) {
            try {
                list = this.session._getFeature(ListService.class).list(file.getParent(), PathCache.empty() == this.cache ? new IndexedListProgressListener(){

                    @Override
                    public void message(String message) {
                    }

                    @Override
                    public void visit(AttributedList<Path> list, int index, Path f) throws ListCanceledException {
                        if (new ListFilteringPredicate(ListFilteringFeature.this.session, file).test(f)) {
                            throw new FilterFoundException(list, f);
                        }
                    }
                } : new DisabledListProgressListener());
                this.cache.put(file.getParent(), list);
            }
            catch (FilterFoundException e) {
                return e.getFile();
            }
        } else {
            list = this.cache.get(file.getParent());
        }
        return list.find(new ListFilteringPredicate(this.session, file));
    }

    public ListFilteringFeature withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }

    private static final class FilterFoundException
    extends ListCanceledException {
        private final Path file;

        public FilterFoundException(AttributedList<Path> chunk, Path file) {
            super(chunk);
            this.file = file;
        }

        @Override
        public Path getFile() {
            return this.file;
        }
    }

    private static final class ListFilteringPredicate
    extends DefaultPathPredicate {
        private final Session<?> session;
        private final Path file;

        public ListFilteringPredicate(Session<?> session, Path file) {
            super(file);
            this.session = session;
            this.file = file;
        }

        @Override
        public boolean test(Path f) {
            if (StringUtils.isNotBlank((CharSequence)f.attributes().getVersionId()) && new DefaultPathPredicate(this.file).test(f)) {
                return true;
            }
            if (f.attributes().isDuplicate()) {
                return false;
            }
            switch (this.session.getCaseSensitivity()) {
                case sensitive: {
                    return new SimplePathPredicate(this.file).test(f);
                }
                case insensitive: {
                    return new CaseInsensitivePathPredicate(this.file).test(f);
                }
            }
            return false;
        }
    }
}

