/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractHostCollection;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.BookmarkNameProvider;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostReaderFactory;
import ch.cyberduck.core.HostWriterFactory;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.local.FileWatcherListener;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.Reader;
import ch.cyberduck.core.serializer.Writer;
import ch.cyberduck.core.text.DefaultLexicographicOrderComparator;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public abstract class AbstractFolderHostCollection
extends AbstractHostCollection
implements FileWatcherListener {
    private static final Logger log = Logger.getLogger(AbstractFolderHostCollection.class);
    public static final Comparator<Host> SORT_BY_NICKNAME = new Comparator<Host>(){

        @Override
        public int compare(Host o1, Host o2) {
            return new DefaultLexicographicOrderComparator().compare(BookmarkNameProvider.toString(o1), BookmarkNameProvider.toString(o2));
        }
    };
    public static final Comparator<Host> SORT_BY_HOSTNAME = new Comparator<Host>(){

        @Override
        public int compare(Host o1, Host o2) {
            return new DefaultLexicographicOrderComparator().compare(o1.getHostname(), o2.getHostname());
        }
    };
    public static final Comparator<Host> SORT_BY_PROTOCOL = new Comparator<Host>(){

        @Override
        public int compare(Host o1, Host o2) {
            return new DefaultLexicographicOrderComparator().compare(o1.getProtocol().getIdentifier(), o2.getProtocol().getIdentifier());
        }
    };
    private final Preferences preferences = PreferencesFactory.get();
    private final Writer<Host> writer = HostWriterFactory.get();
    private final Reader<Host> reader = HostReaderFactory.get();
    protected final Local folder;
    protected static final Filter<Local> FILE_FILTER = new Filter<Local>(){

        @Override
        public boolean accept(Local file) {
            return file.getName().endsWith(".duck");
        }

        @Override
        public Pattern toPattern() {
            return Pattern.compile(".*\\.duck");
        }
    };

    public AbstractFolderHostCollection(Local f) {
        this.folder = f;
    }

    public String getName() {
        return LocaleFactory.localizedString(this.folder.getName());
    }

    public Local getFile(Host bookmark) {
        return LocalFactory.get(this.folder, String.format("%s.duck", bookmark.getUuid()));
    }

    public Local getFolder() {
        return this.folder;
    }

    @Override
    public void sort(Comparator<? super Host> c) {
        if (this.isLocked()) {
            log.debug((Object)"Skip sorting bookmark collection while loading");
        } else {
            super.sort(c);
            this.save();
        }
    }

    protected void save(Host bookmark) {
        try {
            if (!this.folder.exists()) {
                new DefaultLocalDirectoryFeature().mkdir(this.folder);
            }
            Local f = this.getFile(bookmark);
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Save bookmark %s to %s", bookmark, f));
            }
            this.writer.write(bookmark, f);
        }
        catch (AccessDeniedException e) {
            log.warn((Object)String.format("Failure saving item in collection %s", e.getMessage()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws AccessDeniedException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Reloading %s", this.folder.getAbsolute()));
        }
        this.lock();
        try {
            if (!this.folder.exists()) {
                new DefaultLocalDirectoryFeature().mkdir(this.folder);
            }
            AttributedList<Local> bookmarks = this.folder.list().filter(FILE_FILTER);
            for (Local f : bookmarks) {
                try {
                    this.add(this.reader.read(f));
                }
                catch (AccessDeniedException e) {
                    log.error((Object)String.format("Failure %s reading bookmark from %s", e, f));
                }
            }
        }
        finally {
            this.unlock();
        }
        this.sort();
        super.load();
    }

    @Override
    public void collectionItemAdded(Host bookmark) {
        if (!this.isLocked()) {
            this.save(bookmark);
            this.sort();
        }
        super.collectionItemAdded(bookmark);
    }

    @Override
    public void collectionItemRemoved(Host bookmark) {
        if (!this.isLocked()) {
            Local file = this.getFile(bookmark);
            try {
                file.delete();
            }
            catch (AccessDeniedException | NotfoundException e) {
                log.warn((Object)String.format("Failure removing bookmark %s", e.getMessage()));
            }
            this.sort();
        }
        super.collectionItemRemoved(bookmark);
    }

    @Override
    public void collectionItemChanged(Host bookmark) {
        if (!this.isLocked()) {
            this.save(bookmark);
        }
        super.collectionItemChanged(bookmark);
    }
}

