/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.v3.oas.annotations.media.Schema;
import java.util.Objects;

@Schema(description="User Authentication Data")
public class UserAuthData {
    @JsonProperty(value="method")
    private String method = null;
    @JsonProperty(value="login")
    private String login = null;
    @JsonProperty(value="password")
    private String password = null;
    @JsonProperty(value="mustChangePassword")
    private Boolean mustChangePassword = null;
    @JsonProperty(value="adConfigId")
    private Integer adConfigId = null;
    @JsonProperty(value="oidConfigId")
    private Integer oidConfigId = null;

    public UserAuthData method(String method) {
        this.method = method;
        return this;
    }

    @Schema(required=true, description="Authentication method    Authentication methods:  * `basic`  * `active_directory`  * `radius`  * `openid`")
    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public UserAuthData login(String login) {
        this.login = login;
        return this;
    }

    @Schema(description="User login name")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public UserAuthData password(String password) {
        this.password = password;
        return this;
    }

    @Schema(description="Password (only relevant for `basic` authentication type)  *NOT* your Active Directory, OpenID or RADIUS password!")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public UserAuthData mustChangePassword(Boolean mustChangePassword) {
        this.mustChangePassword = mustChangePassword;
        return this;
    }

    @Schema(description="Determines whether user has to change his / her password  * default: `true` for `basic` auth type  * default: `false` for `active_directory`, `openid` and `radius` auth types")
    public Boolean isMustChangePassword() {
        return this.mustChangePassword;
    }

    public void setMustChangePassword(Boolean mustChangePassword) {
        this.mustChangePassword = mustChangePassword;
    }

    public UserAuthData adConfigId(Integer adConfigId) {
        this.adConfigId = adConfigId;
        return this;
    }

    @Schema(description="ID of the user's Active Directory.")
    public Integer getAdConfigId() {
        return this.adConfigId;
    }

    public void setAdConfigId(Integer adConfigId) {
        this.adConfigId = adConfigId;
    }

    public UserAuthData oidConfigId(Integer oidConfigId) {
        this.oidConfigId = oidConfigId;
        return this;
    }

    @Schema(description="ID of the user's OIDC provider.")
    public Integer getOidConfigId() {
        return this.oidConfigId;
    }

    public void setOidConfigId(Integer oidConfigId) {
        this.oidConfigId = oidConfigId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAuthData userAuthData = (UserAuthData)o;
        return Objects.equals(this.method, userAuthData.method) && Objects.equals(this.login, userAuthData.login) && Objects.equals(this.password, userAuthData.password) && Objects.equals(this.mustChangePassword, userAuthData.mustChangePassword) && Objects.equals(this.adConfigId, userAuthData.adConfigId) && Objects.equals(this.oidConfigId, userAuthData.oidConfigId);
    }

    public int hashCode() {
        return Objects.hash(this.method, this.login, this.password, this.mustChangePassword, this.adConfigId, this.oidConfigId);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAuthData {\n");
        sb.append("    method: ").append(this.toIndentedString(this.method)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    mustChangePassword: ").append(this.toIndentedString(this.mustChangePassword)).append("\n");
        sb.append("    adConfigId: ").append(this.toIndentedString(this.adConfigId)).append("\n");
        sb.append("    oidConfigId: ").append(this.toIndentedString(this.oidConfigId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

