/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive.features;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.onedrive.GraphExceptionMappingService;
import ch.cyberduck.core.onedrive.GraphSession;
import ch.cyberduck.core.onedrive.features.GraphAttributesFinderFeature;
import ch.cyberduck.core.onedrive.features.GraphDeleteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.time.Instant;
import java.time.ZoneOffset;
import java.util.Collections;
import org.apache.commons.codec.binary.StringUtils;
import org.nuxeo.onedrive.client.Files;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.PatchOperation;
import org.nuxeo.onedrive.client.types.DriveItem;
import org.nuxeo.onedrive.client.types.Facet;
import org.nuxeo.onedrive.client.types.FileSystemInfo;

public class GraphMoveFeature
implements Move {
    private final GraphSession session;
    private final Delete delete;

    public GraphMoveFeature(GraphSession session) {
        this.session = session;
        this.delete = new GraphDeleteFeature(session);
    }

    public Path move(Path file, Path renamed, TransferStatus status, Delete.Callback callback, ConnectionCallback connectionCallback) throws BackgroundException {
        if (status.isExists()) {
            this.delete.delete(Collections.singletonMap(renamed, status), (PasswordCallback)connectionCallback, callback);
            renamed.attributes().setVersionId(null);
        }
        PatchOperation patchOperation = new PatchOperation();
        if (!StringUtils.equals((CharSequence)file.getName(), (CharSequence)renamed.getName())) {
            patchOperation.rename(renamed.getName());
        }
        if (!file.getParent().equals((Object)renamed.getParent())) {
            DriveItem moveTarget = this.session.toFolder(renamed.getParent());
            patchOperation.move(moveTarget);
        }
        FileSystemInfo info = new FileSystemInfo();
        info.setLastModifiedDateTime(Instant.ofEpochMilli(file.attributes().getModificationDate()).atOffset(ZoneOffset.UTC));
        patchOperation.facet("fileSystemInfo", (Facet)info);
        DriveItem item = this.session.toItem(file);
        try {
            Files.patch((DriveItem)item, (PatchOperation)patchOperation);
        }
        catch (OneDriveAPIException e) {
            throw new GraphExceptionMappingService().map("Cannot rename {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Cannot rename {0}", (Throwable)e, file);
        }
        return new Path(renamed.getParent(), renamed.getName(), renamed.getType(), new GraphAttributesFinderFeature(this.session).find(renamed));
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        if (!this.session.isAccessible(source, false)) {
            return false;
        }
        if (!this.session.getContainer(source).equals(this.session.getContainer(target))) {
            return false;
        }
        return !source.getType().contains(AbstractPath.Type.shared);
    }
}

