/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.manta;

import ch.cyberduck.core.AuthenticationProvider;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.StringAppender;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.manta.MantaSession;
import ch.cyberduck.core.sftp.SSHFingerprintGenerator;
import ch.cyberduck.core.threading.CancelCallback;
import com.hierynomus.sshj.userauth.keyprovider.OpenSSHKeyV1KeyFile;
import com.joyent.manta.client.MantaClient;
import com.joyent.manta.config.SettableConfigContext;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import net.schmizz.sshj.userauth.keyprovider.FileKeyProvider;
import net.schmizz.sshj.userauth.keyprovider.KeyFormat;
import net.schmizz.sshj.userauth.keyprovider.KeyProviderUtil;
import net.schmizz.sshj.userauth.keyprovider.OpenSSHKeyFile;
import net.schmizz.sshj.userauth.keyprovider.PKCS5KeyFile;
import net.schmizz.sshj.userauth.keyprovider.PKCS8KeyFile;
import net.schmizz.sshj.userauth.keyprovider.PuTTYKeyFile;
import net.schmizz.sshj.userauth.password.PasswordFinder;
import net.schmizz.sshj.userauth.password.Resource;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.bouncycastle.openssl.EncryptionException;
import org.bouncycastle.openssl.PasswordException;

public class MantaPublicKeyAuthentication
implements AuthenticationProvider<String> {
    private static final Logger log = Logger.getLogger(MantaPublicKeyAuthentication.class);
    private final MantaSession session;

    public MantaPublicKeyAuthentication(MantaSession session) {
        this.session = session;
    }

    public String authenticate(final Host bookmark, final LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        final Credentials credentials = bookmark.getCredentials();
        final Local identity = credentials.getIdentity();
        KeyFormat format = this.detectKeyFormat(identity);
        FileKeyProvider provider = this.buildProvider(identity, format);
        final SettableConfigContext config = (SettableConfigContext)((MantaClient)this.session.getClient()).getContext();
        config.setMantaKeyPath(identity.getAbsolute());
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Reading private key %s with key format %s", identity, format));
        }
        provider.init((Reader)new InputStreamReader(identity.getInputStream(), StandardCharsets.UTF_8), new PasswordFinder(){

            public char[] reqPassword(Resource<?> resource) {
                if (StringUtils.isEmpty((CharSequence)credentials.getIdentityPassphrase())) {
                    try {
                        Credentials input = prompt.prompt(bookmark, LocaleFactory.localizedString((String)"Private key password protected", (String)"Credentials"), String.format("%s (%s)", LocaleFactory.localizedString((String)"Enter the passphrase for the private key file", (String)"Credentials"), identity.getAbbreviatedPath()), new LoginOptions().icon(bookmark.getProtocol().disk()).user(false).password(true));
                        credentials.setSaved(input.isSaved());
                        credentials.setIdentityPassphrase(input.getPassword());
                    }
                    catch (LoginCanceledException e) {
                        return "".toCharArray();
                    }
                }
                config.setPassword(credentials.getIdentityPassphrase());
                return credentials.getIdentityPassphrase().toCharArray();
            }

            public boolean shouldRetry(Resource<?> resource) {
                return false;
            }
        });
        return this.computeFingerprint(provider);
    }

    public String getMethod() {
        return "publickey";
    }

    private String computeFingerprint(FileKeyProvider provider) throws BackgroundException {
        try {
            return new SSHFingerprintGenerator().fingerprint(provider.getPublic());
        }
        catch (PasswordException e) {
            throw new LoginCanceledException((Throwable)e);
        }
        catch (EncryptionException e) {
            StringAppender appender = new StringAppender();
            appender.append(StringUtils.capitalize((String)e.getMessage()));
            throw new LoginFailureException(appender.toString(), (Throwable)e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    private FileKeyProvider buildProvider(Local identity, KeyFormat format) throws InteroperabilityException {
        switch (format) {
            case PKCS5: {
                return new PKCS5KeyFile.Factory().create();
            }
            case PKCS8: {
                return new PKCS8KeyFile.Factory().create();
            }
            case OpenSSH: {
                return new OpenSSHKeyFile.Factory().create();
            }
            case OpenSSHv1: {
                return new OpenSSHKeyV1KeyFile.Factory().create();
            }
            case PuTTY: {
                return new PuTTYKeyFile.Factory().create();
            }
        }
        throw new InteroperabilityException(String.format("Unknown key format for file %s", identity.getName()));
    }

    private KeyFormat detectKeyFormat(Local identity) throws BackgroundException {
        KeyFormat format;
        try (InputStream is = identity.getInputStream();){
            format = KeyProviderUtil.detectKeyFileFormat((Reader)new InputStreamReader(is, StandardCharsets.UTF_8), (boolean)true);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
        return format;
    }
}

