/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.StreamListener;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.S3MultipartUploadService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3SingleUploadService;
import ch.cyberduck.core.s3.S3WriteFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.log4j.Logger;
import org.jets3t.service.model.StorageObject;

public class S3ThresholdUploadService
implements Upload<StorageObject> {
    private static final Logger log = Logger.getLogger(S3ThresholdUploadService.class);
    private final Preferences preferences = PreferencesFactory.get();
    private final S3Session session;
    private final Long threshold;
    private Write<StorageObject> writer;

    public S3ThresholdUploadService(S3Session session) {
        this(session, PreferencesFactory.get().getLong("s3.upload.multipart.threshold"));
    }

    public S3ThresholdUploadService(S3Session session, Long threshold) {
        this.session = session;
        this.threshold = threshold;
        this.writer = new S3WriteFeature(session);
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        return this.writer.append(file, length, cache);
    }

    public StorageObject upload(Path file, Local local, BandwidthThrottle throttle, StreamListener listener, TransferStatus status, ConnectionCallback prompt) throws BackgroundException {
        if (status.getLength() >= this.threshold) {
            if (!this.preferences.getBoolean("s3.upload.multipart")) {
                log.warn((Object)"Multipart upload is disabled with property s3.upload.multipart");
                if (status.getLength() < this.preferences.getLong("s3.upload.multipart.required.threshold")) {
                    return new S3SingleUploadService(this.session, this.writer).upload(file, local, throttle, listener, status, prompt);
                }
            }
            try {
                return new S3MultipartUploadService(this.session, this.writer).upload(file, local, throttle, listener, status, prompt);
            }
            catch (InteroperabilityException | NotfoundException e) {
                log.warn((Object)String.format("Failure using multipart upload %s. Fallback to single upload.", e.getMessage()));
            }
        }
        return new S3SingleUploadService(this.session, this.writer).upload(file, local, throttle, listener, status, prompt);
    }

    public Upload<StorageObject> withWriter(Write<StorageObject> writer) {
        this.writer = writer;
        return this;
    }
}

