/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.UseragentProvider;
import ch.cyberduck.core.dropbox.DropboxAttributesFinderFeature;
import ch.cyberduck.core.dropbox.DropboxCommonsHttpRequestExecutor;
import ch.cyberduck.core.dropbox.DropboxCopyFeature;
import ch.cyberduck.core.dropbox.DropboxDeleteFeature;
import ch.cyberduck.core.dropbox.DropboxDirectoryFeature;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxFindFeature;
import ch.cyberduck.core.dropbox.DropboxHomeFinderFeature;
import ch.cyberduck.core.dropbox.DropboxListService;
import ch.cyberduck.core.dropbox.DropboxLockFeature;
import ch.cyberduck.core.dropbox.DropboxMoveFeature;
import ch.cyberduck.core.dropbox.DropboxPasswordShareUrlProvider;
import ch.cyberduck.core.dropbox.DropboxPathContainerService;
import ch.cyberduck.core.dropbox.DropboxQuotaFeature;
import ch.cyberduck.core.dropbox.DropboxReadFeature;
import ch.cyberduck.core.dropbox.DropboxRootListService;
import ch.cyberduck.core.dropbox.DropboxSearchFeature;
import ch.cyberduck.core.dropbox.DropboxTouchFeature;
import ch.cyberduck.core.dropbox.DropboxUploadFeature;
import ch.cyberduck.core.dropbox.DropboxUrlProvider;
import ch.cyberduck.core.dropbox.DropboxWriteFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import com.dropbox.core.DbxException;
import com.dropbox.core.DbxHost;
import com.dropbox.core.DbxRequestConfig;
import com.dropbox.core.http.HttpRequestor;
import com.dropbox.core.v2.CustomDbxRawClientV2;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.common.PathRoot;
import com.dropbox.core.v2.users.DbxUserUsersRequests;
import com.dropbox.core.v2.users.FullAccount;
import java.io.IOException;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;

public class DropboxSession
extends HttpSession<CustomDbxRawClientV2> {
    private static final Logger log = Logger.getLogger(DropboxSession.class);
    private final UseragentProvider useragent = new PreferencesUseragentProvider();
    private final DropboxPathContainerService containerService = new DropboxPathContainerService();
    private OAuth2RequestInterceptor authorizationService;
    private Lock<String> locking = null;

    public DropboxSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    protected CustomDbxRawClientV2 connect(Proxy proxy, HostKeyCallback callback, LoginCallback prompt) {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)configuration.build(), this.host.getProtocol()).withRedirectUri(this.host.getProtocol().getOAuthRedirectUrl());
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.host, this.authorizationService, prompt));
        CloseableHttpClient client = configuration.build();
        return new CustomDbxRawClientV2(DbxRequestConfig.newBuilder((String)this.useragent.get()).withAutoRetryDisabled().withHttpRequestor((HttpRequestor)new DropboxCommonsHttpRequestExecutor(client)).build(), DbxHost.DEFAULT, null, null);
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        this.authorizationService.setTokens(this.authorizationService.authorize(this.host, prompt, cancel));
        try {
            Credentials credentials = this.host.getCredentials();
            FullAccount account = new DbxUserUsersRequests((DbxRawClientV2)this.client).getCurrentAccount();
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Authenticated as user %s", account));
            }
            credentials.setUsername(account.getEmail());
            switch (account.getAccountType()) {
                case BUSINESS: {
                    this.locking = new DropboxLockFeature(this);
                }
            }
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map(e);
        }
    }

    protected void logout() throws BackgroundException {
        try {
            ((DropboxCommonsHttpRequestExecutor)((CustomDbxRawClientV2)((Object)this.client)).getRequestConfig().getHttpRequestor()).close();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Home.class) {
            return (T)((Object)new DropboxHomeFinderFeature(this));
        }
        if (type == ListService.class) {
            return (T)(PreferencesFactory.get().getBoolean("dropbox.business.enable") ? new DropboxRootListService(this) : new DropboxListService(this));
        }
        if (type == Read.class) {
            return (T)new DropboxReadFeature(this);
        }
        if (type == Write.class) {
            return (T)((Object)new DropboxWriteFeature(this));
        }
        if (type == Upload.class) {
            return (T)((Object)new DropboxUploadFeature(new DropboxWriteFeature(this)));
        }
        if (type == Directory.class) {
            return (T)new DropboxDirectoryFeature(this);
        }
        if (type == Delete.class) {
            return (T)new DropboxDeleteFeature(this);
        }
        if (type == Move.class) {
            return (T)new DropboxMoveFeature(this);
        }
        if (type == Copy.class) {
            return (T)new DropboxCopyFeature(this);
        }
        if (type == UrlProvider.class) {
            return (T)new DropboxUrlProvider(this);
        }
        if (type == PromptUrlProvider.class) {
            return (T)new DropboxPasswordShareUrlProvider(this);
        }
        if (type == Find.class) {
            return (T)new DropboxFindFeature(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new DropboxAttributesFinderFeature(this);
        }
        if (type == Quota.class) {
            return (T)new DropboxQuotaFeature(this);
        }
        if (type == Touch.class) {
            return (T)((Object)new DropboxTouchFeature(this));
        }
        if (type == Search.class) {
            return (T)new DropboxSearchFeature(this);
        }
        if (type == Lock.class) {
            return (T)this.locking;
        }
        return (T)super._getFeature(type);
    }

    public CustomDbxRawClientV2 getClient() {
        log.warn((Object)String.format("Dropbox-API-Path-Root not set for client %s", this.client));
        return (CustomDbxRawClientV2)((Object)super.getClient());
    }

    public CustomDbxRawClientV2 getClient(Path file) {
        return this.getClient(this.containerService.getNamespace(file));
    }

    protected CustomDbxRawClientV2 getClient(PathRoot root) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Set path root to %s", root));
        }
        return ((CustomDbxRawClientV2)((Object)this.client)).withPathRoot(root);
    }
}

