/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxPathContainerService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import com.dropbox.core.v2.files.FileMetadata;
import com.dropbox.core.v2.files.FolderMetadata;
import com.dropbox.core.v2.files.Metadata;

public class DropboxAttributesFinderFeature
implements AttributesFinder {
    private final DropboxSession session;
    private final PathContainerService containerService = new DropboxPathContainerService();

    public DropboxAttributesFinderFeature(DropboxSession session) {
        this.session = session;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        try {
            Metadata metadata = new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient(file)).getMetadata(this.containerService.getKey(file));
            return this.toAttributes(metadata);
        }
        catch (DbxException e) {
            throw new DropboxExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    protected PathAttributes toAttributes(Metadata metadata) {
        PathAttributes attributes = new PathAttributes();
        if (metadata instanceof FileMetadata) {
            FileMetadata file = (FileMetadata)metadata;
            attributes.setSize(file.getSize());
            attributes.setModificationDate(file.getClientModified().getTime());
            if (file.getFileLockInfo() != null) {
                attributes.setLockId(String.valueOf(file.getFileLockInfo().getIsLockholder()));
            }
        }
        if (metadata instanceof FolderMetadata) {
            FolderMetadata folder = (FolderMetadata)metadata;
            attributes.setVersionId(folder.getSharedFolderId());
        }
        return attributes;
    }
}

