/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginOptions;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PasswordStore;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.cryptomator.ContentReader;
import ch.cyberduck.core.cryptomator.ContentWriter;
import ch.cyberduck.core.cryptomator.CryptoAclPermission;
import ch.cyberduck.core.cryptomator.CryptoAuthenticationException;
import ch.cyberduck.core.cryptomator.CryptoDirectory;
import ch.cyberduck.core.cryptomator.CryptoFilename;
import ch.cyberduck.core.cryptomator.CryptoFilenameMismatchException;
import ch.cyberduck.core.cryptomator.CryptoInvalidFilesizeException;
import ch.cyberduck.core.cryptomator.CryptorCache;
import ch.cyberduck.core.cryptomator.features.CryptoAttributesFeature;
import ch.cyberduck.core.cryptomator.features.CryptoBulkFeature;
import ch.cyberduck.core.cryptomator.features.CryptoCompressFeature;
import ch.cyberduck.core.cryptomator.features.CryptoCopyFeature;
import ch.cyberduck.core.cryptomator.features.CryptoDeleteV6Feature;
import ch.cyberduck.core.cryptomator.features.CryptoDeleteV7Feature;
import ch.cyberduck.core.cryptomator.features.CryptoDirectoryV6Feature;
import ch.cyberduck.core.cryptomator.features.CryptoDirectoryV7Feature;
import ch.cyberduck.core.cryptomator.features.CryptoDownloadFeature;
import ch.cyberduck.core.cryptomator.features.CryptoEncryptionFeature;
import ch.cyberduck.core.cryptomator.features.CryptoFindFeature;
import ch.cyberduck.core.cryptomator.features.CryptoHeadersFeature;
import ch.cyberduck.core.cryptomator.features.CryptoHomeFeature;
import ch.cyberduck.core.cryptomator.features.CryptoIdProvider;
import ch.cyberduck.core.cryptomator.features.CryptoLifecycleFeature;
import ch.cyberduck.core.cryptomator.features.CryptoListService;
import ch.cyberduck.core.cryptomator.features.CryptoLocationFeature;
import ch.cyberduck.core.cryptomator.features.CryptoLockFeature;
import ch.cyberduck.core.cryptomator.features.CryptoLoggingFeature;
import ch.cyberduck.core.cryptomator.features.CryptoMoveV6Feature;
import ch.cyberduck.core.cryptomator.features.CryptoMoveV7Feature;
import ch.cyberduck.core.cryptomator.features.CryptoMultipartWriteFeature;
import ch.cyberduck.core.cryptomator.features.CryptoReadFeature;
import ch.cyberduck.core.cryptomator.features.CryptoRedundancyFeature;
import ch.cyberduck.core.cryptomator.features.CryptoSearchFeature;
import ch.cyberduck.core.cryptomator.features.CryptoSymlinkFeature;
import ch.cyberduck.core.cryptomator.features.CryptoTimestampFeature;
import ch.cyberduck.core.cryptomator.features.CryptoTouchFeature;
import ch.cyberduck.core.cryptomator.features.CryptoTransferAccelerationFeature;
import ch.cyberduck.core.cryptomator.features.CryptoUnixPermission;
import ch.cyberduck.core.cryptomator.features.CryptoUploadFeature;
import ch.cyberduck.core.cryptomator.features.CryptoUrlProvider;
import ch.cyberduck.core.cryptomator.features.CryptoVersioningFeature;
import ch.cyberduck.core.cryptomator.features.CryptoWriteFeature;
import ch.cyberduck.core.cryptomator.impl.CryptoDirectoryV6Provider;
import ch.cyberduck.core.cryptomator.impl.CryptoDirectoryV7Provider;
import ch.cyberduck.core.cryptomator.impl.CryptoFilenameV6Provider;
import ch.cyberduck.core.cryptomator.impl.CryptoFilenameV7Provider;
import ch.cyberduck.core.cryptomator.random.FastSecureRandomProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Bulk;
import ch.cyberduck.core.features.Compress;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Download;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.IdProvider;
import ch.cyberduck.core.features.Lifecycle;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Symlink;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.TransferAcceleration;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Vault;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultTouchFeature;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.unicode.NFCNormalizer;
import ch.cyberduck.core.vault.VaultCredentials;
import ch.cyberduck.core.vault.VaultException;
import com.google.common.io.BaseEncoding;
import com.google.gson.JsonParseException;
import java.nio.charset.StandardCharsets;
import java.security.SecureRandom;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;
import org.cryptomator.cryptolib.Cryptors;
import org.cryptomator.cryptolib.api.AuthenticationFailedException;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.CryptorProvider;
import org.cryptomator.cryptolib.api.FileContentCryptor;
import org.cryptomator.cryptolib.api.FileHeaderCryptor;
import org.cryptomator.cryptolib.api.InvalidPassphraseException;
import org.cryptomator.cryptolib.api.KeyFile;

public class CryptoVault
implements Vault {
    private static final Logger log = Logger.getLogger(CryptoVault.class);
    public static final int VAULT_VERSION_DEPRECATED = 6;
    public static final int VAULT_VERSION = PreferencesFactory.get().getInteger("cryptomator.vault.version");
    public static final String DIR_PREFIX = "0";
    private static final Pattern BASE32_PATTERN = Pattern.compile("^0?(([A-Z2-7]{8})*[A-Z2-7=]{8})");
    private static final Pattern BASE64URL_PATTERN = Pattern.compile("^([A-Za-z0-9_=-]+).c9r");
    private final Path home;
    private final Path masterkey;
    private final Path vault;
    private int vaultVersion;
    private final Preferences preferences = PreferencesFactory.get();
    private Cryptor cryptor;
    private CryptorCache fileNameCryptor;
    private CryptoFilename filenameProvider;
    private CryptoDirectory directoryProvider;
    private final byte[] pepper;

    public CryptoVault(Path home) {
        this(home, "masterkey.cryptomator");
    }

    public CryptoVault(Path home, String masterkey) {
        this(home, masterkey, new byte[0]);
    }

    public CryptoVault(Path home, String masterkey, byte[] pepper) {
        this.home = home;
        this.masterkey = new Path(home, masterkey, EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.vault));
        this.pepper = pepper;
        EnumSet<AbstractPath.Type> type = EnumSet.copyOf(home.getType());
        type.add(AbstractPath.Type.vault);
        this.vault = home.isRoot() ? new Path(home.getAbsolute(), type, new PathAttributes(home.attributes())) : new Path(home.getParent(), home.getName(), type, new PathAttributes(home.attributes()));
    }

    public synchronized Path create(Session<?> session, String region, VaultCredentials credentials, PasswordStore keychain, int version) throws BackgroundException {
        Redundancy redundancy;
        CryptorProvider provider = Cryptors.version1((SecureRandom)FastSecureRandomProvider.get().provide());
        Host bookmark = session.getHost();
        if (credentials.isSaved()) {
            try {
                keychain.addPassword(String.format("Cryptomator Passphrase (%s)", bookmark.getCredentials().getUsername()), new DefaultUrlProvider(bookmark).toUrl(this.masterkey).find(DescriptiveUrl.Type.provider).getUrl(), credentials.getPassword());
            }
            catch (LocalAccessDeniedException e) {
                log.error((Object)String.format("Failure %s saving credentials for %s in password store", new Object[]{e, bookmark}));
            }
        }
        String passphrase = credentials.getPassword();
        KeyFile masterKeyFileContent = provider.createNew().writeKeysToMasterkeyFile((CharSequence)passphrase, this.pepper, version);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Write master key to %s", this.masterkey));
        }
        Directory directory = (Directory)session._getFeature(Directory.class);
        TransferStatus status = new TransferStatus();
        Encryption encryption = (Encryption)session.getFeature(Encryption.class);
        if (encryption != null) {
            status.setEncryption(encryption.getDefault(this.home));
        }
        if ((redundancy = (Redundancy)session.getFeature(Redundancy.class)) != null) {
            status.setStorageClass(redundancy.getDefault());
        }
        Path vault = directory.mkdir(this.home, region, status);
        new ContentWriter(session).write(this.masterkey, masterKeyFileContent.serialize());
        this.open(KeyFile.parse((byte[])masterKeyFileContent.serialize()), passphrase);
        Path secondLevel = this.directoryProvider.toEncrypted(session, this.home.attributes().getDirectoryId(), this.home);
        Path firstLevel = secondLevel.getParent();
        Path dataDir = firstLevel.getParent();
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Create vault root directory at %s", secondLevel));
        }
        directory.mkdir(dataDir, region, status);
        directory.mkdir(firstLevel, region, status);
        directory.mkdir(secondLevel, region, status);
        return vault;
    }

    public synchronized Path create(Session<?> session, String region, VaultCredentials credentials, PasswordStore keychain) throws BackgroundException {
        return this.create(session, region, credentials, keychain, VAULT_VERSION);
    }

    public synchronized CryptoVault load(Session<?> session, PasswordCallback prompt, PasswordStore keychain) throws BackgroundException {
        KeyFile masterKeyFileContent;
        if (this.isUnlocked()) {
            log.warn((Object)String.format("Skip unlock of open vault %s", this));
            return this;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Attempt to read master key from %s", this.masterkey));
        }
        String json = new ContentReader(session).read(this.masterkey);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Read master key %s", this.masterkey));
        }
        try {
            masterKeyFileContent = KeyFile.parse((byte[])json.getBytes());
        }
        catch (JsonParseException | IllegalArgumentException | IllegalStateException e) {
            throw new VaultException(String.format("Failure reading vault master key file %s", this.masterkey.getName()), e);
        }
        Host bookmark = session.getHost();
        String passphrase = keychain.getPassword(String.format("Cryptomator Passphrase (%s)", bookmark.getCredentials().getUsername()), new DefaultUrlProvider(bookmark).toUrl(this.masterkey).find(DescriptiveUrl.Type.provider).getUrl());
        if (null == passphrase) {
            passphrase = keychain.getPassword(String.format("Cryptomator Passphrase %s", bookmark.getHostname()), new DefaultUrlProvider(bookmark).toUrl(this.masterkey).find(DescriptiveUrl.Type.provider).getUrl());
        }
        this.unlock(session, this.masterkey, masterKeyFileContent, passphrase, bookmark, prompt, MessageFormat.format(LocaleFactory.localizedString((String)"Provide your passphrase to unlock the Cryptomator Vault {0}", (String)"Cryptomator"), this.home.getName()), keychain);
        return this;
    }

    private void unlock(Session<?> session, Path masterKeyFile, KeyFile masterKeyFileContent, String passphrase, Host bookmark, PasswordCallback prompt, String message, PasswordStore keychain) throws BackgroundException {
        VaultCredentials credentials;
        if (null == passphrase) {
            credentials = prompt.prompt(bookmark, LocaleFactory.localizedString((String)"Unlock Vault", (String)"Cryptomator"), message, new LoginOptions().user(false).anonymous(false).icon("cryptomator.tiff").passwordPlaceholder(LocaleFactory.localizedString((String)"Passphrase", (String)"Cryptomator")));
            if (null == credentials.getPassword()) {
                throw new LoginCanceledException();
            }
        } else {
            credentials = new VaultCredentials(passphrase).withSaved(this.preferences.getBoolean("vault.keychain"));
        }
        try {
            this.open(this.upgrade(session, masterKeyFileContent, credentials.getPassword()), credentials.getPassword());
            if (credentials.isSaved()) {
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Save passphrase for %s", masterKeyFile));
                }
                keychain.addPassword(String.format("Cryptomator Passphrase (%s)", bookmark.getCredentials().getUsername()), new DefaultUrlProvider(bookmark).toUrl(masterKeyFile).find(DescriptiveUrl.Type.provider).getUrl(), credentials.getPassword());
                this.preferences.setProperty(new DefaultUrlProvider(bookmark).toUrl(masterKeyFile).find(DescriptiveUrl.Type.provider).getUrl(), new String(masterKeyFileContent.serialize()));
            }
        }
        catch (CryptoAuthenticationException e) {
            this.unlock(session, masterKeyFile, masterKeyFileContent, null, bookmark, prompt, String.format("%s %s.", e.getDetail(), MessageFormat.format(LocaleFactory.localizedString((String)"Provide your passphrase to unlock the Cryptomator Vault {0}", (String)"Cryptomator"), this.home.getName())), keychain);
        }
    }

    public synchronized void close() {
        if (this.isUnlocked()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Close vault with cryptor %s", this.cryptor));
            }
            if (this.cryptor != null) {
                this.cryptor.destroy();
            }
            if (this.directoryProvider != null) {
                this.directoryProvider.destroy();
            }
            if (this.filenameProvider != null) {
                this.filenameProvider.destroy();
            }
        }
        this.cryptor = null;
        this.fileNameCryptor = null;
    }

    private KeyFile upgrade(Session<?> session, KeyFile keyFile, CharSequence passphrase) throws BackgroundException {
        int version = keyFile.getVersion();
        if (version == VAULT_VERSION || version == 6) {
            return keyFile;
        }
        if (version == 5) {
            log.warn((Object)String.format("Upgrade vault version %d to %d", keyFile.getVersion(), VAULT_VERSION));
            try {
                CryptorProvider provider = Cryptors.version1((SecureRandom)FastSecureRandomProvider.get().provide());
                Cryptor cryptor = provider.createFromKeyFile(keyFile, passphrase, this.pepper, keyFile.getVersion());
                Path masterKeyFileBackup = new Path(this.home, "masterkey.cryptomator.bkup", EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.vault));
                new ContentWriter(session).write(masterKeyFileBackup, keyFile.serialize());
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Master key backup saved in %s", masterKeyFileBackup));
                }
                KeyFile upgradedMasterKeyFile = cryptor.writeKeysToMasterkeyFile(passphrase, this.pepper, 6);
                Path masterKeyFile = new Path(this.home, "masterkey.cryptomator", EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.vault));
                byte[] masterKeyFileContent = upgradedMasterKeyFile.serialize();
                new ContentWriter(session).write(masterKeyFile, masterKeyFileContent, new TransferStatus().exists(true).length((long)masterKeyFileContent.length));
                log.warn((Object)String.format("Updated masterkey %s to version %d", masterKeyFile, 6));
                return KeyFile.parse((byte[])upgradedMasterKeyFile.serialize());
            }
            catch (IllegalArgumentException e) {
                throw new VaultException("Failure reading key file", (Throwable)e);
            }
            catch (InvalidPassphraseException e) {
                throw new CryptoAuthenticationException("Failure to decrypt master key file", e);
            }
        }
        log.error((Object)String.format("Unsupported vault version %d", keyFile.getVersion()));
        return keyFile;
    }

    protected void open(KeyFile keyFile, CharSequence passphrase) throws VaultException, CryptoAuthenticationException {
        switch (keyFile.getVersion()) {
            case 6: {
                this.open(keyFile, passphrase, new CryptoFilenameV6Provider(this.vault), new CryptoDirectoryV6Provider(this.vault, this));
                break;
            }
            default: {
                this.open(keyFile, passphrase, new CryptoFilenameV7Provider(), new CryptoDirectoryV7Provider(this.vault, this));
            }
        }
    }

    protected void open(KeyFile keyFile, CharSequence passphrase, CryptoFilename filenameProvider, CryptoDirectory directoryProvider) throws VaultException, CryptoAuthenticationException {
        this.vaultVersion = keyFile.getVersion();
        CryptorProvider provider = Cryptors.version1((SecureRandom)FastSecureRandomProvider.get().provide());
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Initialized crypto provider %s", provider));
        }
        try {
            this.cryptor = provider.createFromKeyFile(keyFile, new NFCNormalizer().normalize(passphrase), this.pepper, keyFile.getVersion());
            this.fileNameCryptor = new CryptorCache(this.cryptor.fileNameCryptor());
            this.filenameProvider = filenameProvider;
            this.directoryProvider = directoryProvider;
        }
        catch (IllegalArgumentException e) {
            throw new VaultException("Failure reading key file", (Throwable)e);
        }
        catch (InvalidPassphraseException e) {
            throw new CryptoAuthenticationException("Failure to decrypt master key file", e);
        }
    }

    public synchronized boolean isUnlocked() {
        return this.cryptor != null;
    }

    public Vault.State getState() {
        return this.isUnlocked() ? Vault.State.open : Vault.State.closed;
    }

    public boolean contains(Path file) {
        if (this.isUnlocked()) {
            return new SimplePathPredicate(file).test(this.home) || file.isChild(this.home);
        }
        return false;
    }

    public Path encrypt(Session<?> session, Path file) throws BackgroundException {
        return this.encrypt(session, file, file.attributes().getDirectoryId(), false);
    }

    public Path encrypt(Session<?> session, Path file, boolean metadata) throws BackgroundException {
        return this.encrypt(session, file, file.attributes().getDirectoryId(), metadata);
    }

    public Path encrypt(Session<?> session, Path file, String directoryId, boolean metadata) throws BackgroundException {
        Path encrypted;
        if (file.isFile() || metadata) {
            String filename;
            Path parent;
            if (file.getType().contains(AbstractPath.Type.vault)) {
                log.warn((Object)String.format("Skip file %s because it is marked as an internal vault path", file));
                return file;
            }
            if (new SimplePathPredicate(file).test(this.home)) {
                log.warn((Object)String.format("Skip vault home %s because the root has no metadata file", file));
                return file;
            }
            if (file.getType().contains(AbstractPath.Type.encrypted)) {
                Path decrypted = file.attributes().getDecrypted();
                parent = this.directoryProvider.toEncrypted(session, decrypted.getParent().attributes().getDirectoryId(), decrypted.getParent());
                filename = this.directoryProvider.toEncrypted(session, parent.attributes().getDirectoryId(), decrypted.getName(), decrypted.getType());
            } else {
                parent = this.directoryProvider.toEncrypted(session, file.getParent().attributes().getDirectoryId(), file.getParent());
                filename = this.directoryProvider.toEncrypted(session, parent.attributes().getDirectoryId(), file.getName(), file.getType());
            }
            PathAttributes attributes = new PathAttributes(file.attributes());
            attributes.setDirectoryId(null);
            if (metadata) {
                attributes.setVersionId(null);
            }
            attributes.setSize(this.toCiphertextSize(file.attributes().getSize()));
            EnumSet<AbstractPath.Type> type = EnumSet.copyOf(file.getType());
            if (metadata && this.vaultVersion == 6) {
                type.remove(AbstractPath.Type.directory);
                type.add(AbstractPath.Type.file);
            }
            type.remove(AbstractPath.Type.decrypted);
            type.add(AbstractPath.Type.encrypted);
            encrypted = new Path(parent, filename, type, attributes);
        } else {
            if (file.getType().contains(AbstractPath.Type.encrypted)) {
                log.warn((Object)String.format("Skip file %s because it is already marked as an encrypted path", file));
                return file;
            }
            if (file.getType().contains(AbstractPath.Type.vault)) {
                return this.directoryProvider.toEncrypted(session, this.home.attributes().getDirectoryId(), this.home);
            }
            encrypted = this.directoryProvider.toEncrypted(session, directoryId, file);
        }
        if (!file.getType().contains(AbstractPath.Type.encrypted)) {
            encrypted.attributes().setDecrypted(file);
        }
        file.attributes().setVault(this.home);
        encrypted.attributes().setVault(this.home);
        return encrypted;
    }

    public Path decrypt(Session<?> session, Path file) throws BackgroundException {
        Path inflated;
        if (file.getType().contains(AbstractPath.Type.decrypted)) {
            log.warn((Object)String.format("Skip file %s because it is already marked as an decrypted path", file));
            return file;
        }
        if (file.getType().contains(AbstractPath.Type.vault)) {
            log.warn((Object)String.format("Skip file %s because it is marked as an internal vault path", file));
            return file;
        }
        Pattern pattern = this.vaultVersion == 6 ? BASE32_PATTERN : BASE64URL_PATTERN;
        Matcher m = pattern.matcher((inflated = this.inflate(session, file)).getName());
        if (m.matches()) {
            String ciphertext = m.group(1);
            try {
                String cleartextFilename = this.fileNameCryptor.decryptFilename(this.vaultVersion == 6 ? BaseEncoding.base32() : BaseEncoding.base64Url(), ciphertext, file.getParent().attributes().getDirectoryId().getBytes(StandardCharsets.UTF_8));
                PathAttributes attributes = new PathAttributes(file.attributes());
                if (this.isDirectory(inflated)) {
                    Permission permission = attributes.getPermission();
                    permission.setUser(permission.getUser().or(Permission.Action.execute));
                    permission.setGroup(permission.getGroup().or(Permission.Action.execute));
                    permission.setOther(permission.getOther().or(Permission.Action.execute));
                    attributes.setSize(-1L);
                    attributes.setVersionId(null);
                } else {
                    attributes.setSize(this.toCleartextSize(file.attributes().getSize()));
                }
                attributes.setEncrypted(file);
                attributes.setVault(this.home);
                EnumSet<AbstractPath.Type> type = EnumSet.copyOf(file.getType());
                type.remove(this.isDirectory(inflated) ? AbstractPath.Type.file : AbstractPath.Type.directory);
                type.add(this.isDirectory(inflated) ? AbstractPath.Type.directory : AbstractPath.Type.file);
                type.remove(AbstractPath.Type.encrypted);
                type.add(AbstractPath.Type.decrypted);
                Path decrypted = new Path(file.getParent().attributes().getDecrypted(), cleartextFilename, type, attributes);
                if (type.contains(AbstractPath.Type.symboliclink)) {
                    decrypted.setSymlinkTarget(file.getSymlinkTarget());
                }
                return decrypted;
            }
            catch (AuthenticationFailedException e) {
                throw new CryptoAuthenticationException("Failure to decrypt due to an unauthentic ciphertext", e);
            }
        }
        throw new CryptoFilenameMismatchException(String.format("Failure to decrypt %s due to missing pattern match for %s", inflated.getName(), pattern));
    }

    private boolean isDirectory(Path p) {
        if (this.vaultVersion == 6) {
            return p.getName().startsWith(DIR_PREFIX);
        }
        return p.isDirectory();
    }

    public long toCiphertextSize(long cleartextFileSize) {
        if (-1L == cleartextFileSize) {
            return -1L;
        }
        return (long)this.cryptor.fileHeaderCryptor().headerSize() + Cryptors.ciphertextSize((long)cleartextFileSize, (Cryptor)this.cryptor);
    }

    public long toCleartextSize(long ciphertextFileSize) throws CryptoInvalidFilesizeException {
        if (-1L == ciphertextFileSize) {
            return -1L;
        }
        int headerSize = this.cryptor.fileHeaderCryptor().headerSize();
        try {
            return Cryptors.cleartextSize((long)(ciphertextFileSize - (long)headerSize), (Cryptor)this.cryptor);
        }
        catch (AssertionError e) {
            throw new CryptoInvalidFilesizeException(String.format("Encrypted file size must be at least %d bytes", headerSize));
        }
        catch (IllegalArgumentException e) {
            throw new CryptoInvalidFilesizeException(String.format("Invalid file size. %s", e.getMessage()));
        }
    }

    private Path inflate(Session<?> session, Path file) throws BackgroundException {
        String fileName = file.getName();
        if (this.filenameProvider.isDeflated(fileName)) {
            String filename = this.filenameProvider.inflate(session, fileName);
            return new Path(file.getParent(), filename, EnumSet.of(AbstractPath.Type.file), file.attributes());
        }
        return file;
    }

    public Path getHome() {
        return this.home;
    }

    public Path getMasterkey() {
        return this.masterkey;
    }

    public FileHeaderCryptor getFileHeaderCryptor() {
        return this.cryptor.fileHeaderCryptor();
    }

    public FileContentCryptor getFileContentCryptor() {
        return this.cryptor.fileContentCryptor();
    }

    public CryptorCache getFileNameCryptor() {
        return this.fileNameCryptor;
    }

    public CryptoFilename getFilenameProvider() {
        return this.filenameProvider;
    }

    public CryptoDirectory getDirectoryProvider() {
        return this.directoryProvider;
    }

    public int numberOfChunks(long cleartextFileSize) {
        return (int)(cleartextFileSize / (long)this.cryptor.fileContentCryptor().cleartextChunkSize() + (long)(cleartextFileSize % (long)this.cryptor.fileContentCryptor().cleartextChunkSize() > 0L ? 1 : 0));
    }

    public <T> T getFeature(Session<?> session, Class<T> type, T delegate) {
        if (this.isUnlocked()) {
            if (type == ListService.class) {
                return (T)new CryptoListService(session, (ListService)delegate, this);
            }
            if (type == Touch.class) {
                return (T)new CryptoTouchFeature(session, new DefaultTouchFeature((Upload)session._getFeature(Upload.class), (AttributesFinder)session._getFeature(AttributesFinder.class)), (Write)session._getFeature(Write.class), this);
            }
            if (type == Directory.class) {
                return (T)(this.vaultVersion == 6 ? new CryptoDirectoryV6Feature(session, (Directory)delegate, (Write)session._getFeature(Write.class), this) : new CryptoDirectoryV7Feature(session, (Directory)delegate, (Write)session._getFeature(Write.class), this));
            }
            if (type == Upload.class) {
                return (T)new CryptoUploadFeature(session, (Upload)delegate, (Write)session._getFeature(Write.class), this);
            }
            if (type == Download.class) {
                return (T)new CryptoDownloadFeature(session, (Download)delegate, (Read)session._getFeature(Read.class), this);
            }
            if (type == Read.class) {
                return (T)new CryptoReadFeature(session, (Read)delegate, this);
            }
            if (type == Write.class) {
                return (T)new CryptoWriteFeature(session, (Write)delegate, this);
            }
            if (type == MultipartWrite.class) {
                return (T)new CryptoMultipartWriteFeature(session, (Write)delegate, this);
            }
            if (type == Move.class) {
                return (T)(this.vaultVersion == 6 ? new CryptoMoveV6Feature(session, (Move)delegate, this) : new CryptoMoveV7Feature(session, (Move)delegate, this));
            }
            if (type == AttributesFinder.class) {
                return (T)new CryptoAttributesFeature(session, (AttributesFinder)delegate, this);
            }
            if (type == Find.class) {
                return (T)new CryptoFindFeature(session, (Find)delegate, this);
            }
            if (type == UrlProvider.class) {
                return (T)new CryptoUrlProvider(session, (UrlProvider)delegate, this);
            }
            if (type == IdProvider.class) {
                return (T)new CryptoIdProvider(session, (IdProvider)delegate, this);
            }
            if (type == Delete.class) {
                return (T)(this.vaultVersion == 6 ? new CryptoDeleteV6Feature(session, (Delete)delegate, this) : new CryptoDeleteV7Feature(session, (Delete)delegate, this));
            }
            if (type == Symlink.class) {
                return (T)new CryptoSymlinkFeature(session, (Symlink)delegate, this);
            }
            if (type == Headers.class) {
                return (T)new CryptoHeadersFeature(session, (Headers)delegate, this);
            }
            if (type == Compress.class) {
                return (T)new CryptoCompressFeature(session, (Compress)delegate, this);
            }
            if (type == Bulk.class) {
                return (T)new CryptoBulkFeature(session, (Bulk)delegate, (Delete)session._getFeature(Delete.class), this);
            }
            if (type == UnixPermission.class) {
                return (T)new CryptoUnixPermission(session, (UnixPermission)delegate, this);
            }
            if (type == AclPermission.class) {
                return (T)new CryptoAclPermission(session, (AclPermission)delegate, this);
            }
            if (type == Copy.class) {
                return (T)new CryptoCopyFeature(session, (Copy)delegate, this);
            }
            if (type == Timestamp.class) {
                return (T)new CryptoTimestampFeature(session, (Timestamp)delegate, this);
            }
            if (type == Encryption.class) {
                return (T)new CryptoEncryptionFeature(session, (Encryption)delegate, this);
            }
            if (type == Lifecycle.class) {
                return (T)new CryptoLifecycleFeature(session, (Lifecycle)delegate, this);
            }
            if (type == Location.class) {
                return (T)new CryptoLocationFeature(session, (Location)delegate, this);
            }
            if (type == Lock.class) {
                return (T)new CryptoLockFeature(session, (Lock)delegate, this);
            }
            if (type == Logging.class) {
                return (T)new CryptoLoggingFeature(session, (Logging)delegate, this);
            }
            if (type == Redundancy.class) {
                return (T)new CryptoRedundancyFeature(session, (Redundancy)delegate, this);
            }
            if (type == Search.class) {
                return (T)new CryptoSearchFeature(session, (Search)delegate, this);
            }
            if (type == TransferAcceleration.class) {
                return (T)new CryptoTransferAccelerationFeature(session, (TransferAcceleration)delegate, this);
            }
            if (type == Versioning.class) {
                return (T)new CryptoVersioningFeature(session, (Versioning)delegate, this);
            }
            if (type == Home.class) {
                return (T)new CryptoHomeFeature(session, (Home)delegate, this);
            }
        }
        return delegate;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof CryptoVault)) {
            return false;
        }
        CryptoVault that = (CryptoVault)o;
        return new SimplePathPredicate(this.home).test(that.home);
    }

    public int hashCode() {
        return Objects.hash(this.home);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoVault{");
        sb.append("home=").append(this.home);
        sb.append(", cryptor=").append(this.cryptor);
        sb.append('}');
        return sb.toString();
    }
}

