/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.protovalues.ChecksumEncodingEnum;

public class TransferOptions {
    public static final int DEFAULT_UDP_SEND_RATE = 600000;
    public static final int DEFAULT_UDP_PACKET_SIZE = 8192;
    public static final int DEFAULT_MAX_PARALLEL_THREADS = 4;
    private int maxThreads = 4;
    private int udpSendRate = 600000;
    private int udpPacketSize = 8192;
    private boolean allowPutGetResourceRedirects = false;
    private boolean intraFileStatusCallbacks = false;
    private ForceOption forceOption = ForceOption.ASK_CALLBACK_LISTENER;
    private boolean useParallelTransfer = true;
    private ChecksumEncodingEnum checksumEncoding = ChecksumEncodingEnum.DEFAULT;
    private int intraFileStatusCallbacksNumberCallsInterval = 5;
    private long intraFileStatusCallbacksTotalBytesInterval = 0x400000L;
    private PutOptions putOption = PutOptions.NORMAL;
    private boolean computeChecksumAfterTransfer = false;
    private boolean computeAndVerifyChecksumAfterTransfer = false;

    public synchronized String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("TransferOptions [maxThreads=");
        builder.append(this.maxThreads);
        builder.append(", udpSendRate=");
        builder.append(this.udpSendRate);
        builder.append(", udpPacketSize=");
        builder.append(this.udpPacketSize);
        builder.append(", allowPutGetResourceRedirects=");
        builder.append(this.allowPutGetResourceRedirects);
        builder.append(", intraFileStatusCallbacks=");
        builder.append(this.intraFileStatusCallbacks);
        builder.append(", ");
        if (this.forceOption != null) {
            builder.append("forceOption=");
            builder.append((Object)this.forceOption);
            builder.append(", ");
        }
        builder.append("useParallelTransfer=");
        builder.append(this.useParallelTransfer);
        builder.append(", ");
        if (this.checksumEncoding != null) {
            builder.append("checksumEncoding=");
            builder.append((Object)this.checksumEncoding);
            builder.append(", ");
        }
        builder.append("intraFileStatusCallbacksNumberCallsInterval=");
        builder.append(this.intraFileStatusCallbacksNumberCallsInterval);
        builder.append(", intraFileStatusCallbacksTotalBytesInterval=");
        builder.append(this.intraFileStatusCallbacksTotalBytesInterval);
        builder.append(", ");
        if (this.putOption != null) {
            builder.append("putOption=");
            builder.append((Object)this.putOption);
            builder.append(", ");
        }
        builder.append("computeChecksumAfterTransfer=");
        builder.append(this.computeChecksumAfterTransfer);
        builder.append(", computeAndVerifyChecksumAfterTransfer=");
        builder.append(this.computeAndVerifyChecksumAfterTransfer);
        builder.append("]");
        return builder.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TransferOptions(TransferOptions transferOptions) {
        this();
        if (transferOptions != null) {
            TransferOptions transferOptions2 = this;
            synchronized (transferOptions2) {
                this.setMaxThreads(transferOptions.getMaxThreads());
                this.setUdpPacketSize(transferOptions.getUdpPacketSize());
                this.setUdpSendRate(transferOptions.getUdpSendRate());
                this.setAllowPutGetResourceRedirects(transferOptions.isAllowPutGetResourceRedirects());
                this.setComputeChecksumAfterTransfer(transferOptions.isComputeChecksumAfterTransfer());
                this.setComputeAndVerifyChecksumAfterTransfer(transferOptions.isComputeAndVerifyChecksumAfterTransfer());
                this.setIntraFileStatusCallbacks(transferOptions.intraFileStatusCallbacks);
                this.setForceOption(transferOptions.getForceOption());
                this.setUseParallelTransfer(transferOptions.isUseParallelTransfer());
                this.setPutOption(transferOptions.getPutOption());
                this.setChecksumEncoding(transferOptions.getChecksumEncoding());
                this.setIntraFileStatusCallbacksNumberCallsInterval(transferOptions.getIntraFileStatusCallbacksNumberCallsInterval());
                this.setIntraFileStatusCallbacksTotalBytesInterval(transferOptions.getIntraFileStatusCallbacksTotalBytesInterval());
            }
        }
    }

    public TransferOptions() {
    }

    public synchronized int getMaxThreads() {
        return this.maxThreads;
    }

    public synchronized void setMaxThreads(int maxThreads) {
        this.maxThreads = maxThreads;
    }

    public synchronized int getUdpSendRate() {
        return this.udpSendRate;
    }

    public synchronized void setUdpSendRate(int udpSendRate) {
        this.udpSendRate = udpSendRate;
    }

    public synchronized int getUdpPacketSize() {
        return this.udpPacketSize;
    }

    public synchronized void setUdpPacketSize(int udpPacketSize) {
        this.udpPacketSize = udpPacketSize;
    }

    public synchronized boolean isAllowPutGetResourceRedirects() {
        return this.allowPutGetResourceRedirects;
    }

    public synchronized void setAllowPutGetResourceRedirects(boolean allowPutGetResourceRedirects) {
        this.allowPutGetResourceRedirects = allowPutGetResourceRedirects;
    }

    public synchronized void setComputeChecksumAfterTransfer(boolean computeChecksumAfterTransfer) {
        this.computeChecksumAfterTransfer = computeChecksumAfterTransfer;
    }

    public synchronized boolean isComputeChecksumAfterTransfer() {
        return this.computeChecksumAfterTransfer;
    }

    public synchronized void setComputeAndVerifyChecksumAfterTransfer(boolean computeAndVerifyChecksumAfterTransfer) {
        this.computeAndVerifyChecksumAfterTransfer = computeAndVerifyChecksumAfterTransfer;
    }

    public synchronized boolean isComputeAndVerifyChecksumAfterTransfer() {
        return this.computeAndVerifyChecksumAfterTransfer;
    }

    public synchronized boolean isIntraFileStatusCallbacks() {
        return this.intraFileStatusCallbacks;
    }

    public synchronized void setIntraFileStatusCallbacks(boolean intraFileStatusCallbacks) {
        this.intraFileStatusCallbacks = intraFileStatusCallbacks;
    }

    public synchronized ForceOption getForceOption() {
        return this.forceOption;
    }

    public synchronized void setForceOption(ForceOption forceOption) {
        this.forceOption = forceOption;
    }

    public synchronized boolean isUseParallelTransfer() {
        return this.useParallelTransfer;
    }

    public synchronized void setUseParallelTransfer(boolean useParallelTransfer) {
        this.useParallelTransfer = useParallelTransfer;
    }

    public synchronized PutOptions getPutOption() {
        return this.putOption;
    }

    public synchronized void setPutOption(PutOptions putOption) {
        this.putOption = putOption;
    }

    public synchronized ChecksumEncodingEnum getChecksumEncoding() {
        return this.checksumEncoding;
    }

    public synchronized void setChecksumEncoding(ChecksumEncodingEnum checksumEncoding) {
        if (checksumEncoding == null) {
            throw new IllegalArgumentException("null checksumEncoding");
        }
        this.checksumEncoding = checksumEncoding;
    }

    public synchronized int getIntraFileStatusCallbacksNumberCallsInterval() {
        return this.intraFileStatusCallbacksNumberCallsInterval;
    }

    public synchronized void setIntraFileStatusCallbacksNumberCallsInterval(int intraFileStatusCallbacksNumberCallsInterval) {
        this.intraFileStatusCallbacksNumberCallsInterval = intraFileStatusCallbacksNumberCallsInterval;
    }

    public synchronized long getIntraFileStatusCallbacksTotalBytesInterval() {
        return this.intraFileStatusCallbacksTotalBytesInterval;
    }

    public synchronized void setIntraFileStatusCallbacksTotalBytesInterval(long intraFileStatusCallbacksTotalBytesInterval) {
        this.intraFileStatusCallbacksTotalBytesInterval = intraFileStatusCallbacksTotalBytesInterval;
    }

    public static enum PutOptions {
        NORMAL,
        MSSO_FILE;

    }

    public static enum ForceOption {
        USE_FORCE,
        NO_FORCE,
        ASK_CALLBACK_LISTENER;

    }
}

