/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.azure.storage.core;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.microsoft.azure.storage.OperationContext;
import com.microsoft.azure.storage.RequestOptions;
import com.microsoft.azure.storage.ResultContinuation;
import com.microsoft.azure.storage.ResultContinuationType;
import com.microsoft.azure.storage.StorageErrorCode;
import com.microsoft.azure.storage.StorageException;
import com.microsoft.azure.storage.StorageExtendedErrorInformation;
import com.microsoft.azure.storage.core.Base64;
import com.microsoft.azure.storage.core.Logger;
import com.microsoft.azure.storage.core.RequestLocationMode;
import com.microsoft.azure.storage.core.StorageRequest;
import com.microsoft.azure.storage.core.StreamMd5AndLength;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.Constructor;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.DateFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeoutException;
import javax.crypto.Cipher;
import javax.crypto.CipherOutputStream;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.xml.sax.SAXException;

public final class Utility {
    private static ThreadLocal<DateFormat> RFC1123_GMT_DATE_TIME_FORMATTER = new ThreadLocal<DateFormat>(){

        @Override
        protected DateFormat initialValue() {
            SimpleDateFormat formatter = new SimpleDateFormat(Utility.RFC1123_PATTERN, LOCALE_US);
            formatter.setTimeZone(GMT_ZONE);
            return formatter;
        }
    };
    public static final TimeZone GMT_ZONE = TimeZone.getTimeZone("GMT");
    public static final TimeZone UTC_ZONE = TimeZone.getTimeZone("UTC");
    public static final Locale LOCALE_US = Locale.US;
    private static final String RFC1123_PATTERN = "EEE, dd MMM yyyy HH:mm:ss z";
    private static final String ISO8601_PATTERN_NO_SECONDS = "yyyy-MM-dd'T'HH:mm'Z'";
    private static final String ISO8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ss'Z'";
    private static final String JAVA_ISO8601_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS'Z'";
    private static final List<Integer> pathStylePorts = Arrays.asList(10000, 10001, 10002, 10003, 10004, 10100, 10101, 10102, 10103, 10104, 11000, 11001, 11002, 11003, 11004, 11100, 11101, 11102, 11103, 11104);
    private static final JsonFactory jsonFactory = new JsonFactory();
    private static final ThreadLocal<SAXParser> saxParserThreadLocal = new ThreadLocal<SAXParser>(){
        SAXParserFactory factory;

        @Override
        public SAXParser initialValue() {
            this.factory = SAXParserFactory.newInstance();
            this.factory.setNamespaceAware(true);
            try {
                return this.factory.newSAXParser();
            }
            catch (SAXException e) {
                throw new RuntimeException("Unable to create SAXParser", e);
            }
            catch (ParserConfigurationException e) {
                throw new RuntimeException("Check parser configuration", e);
            }
        }
    };
    private static final XMLOutputFactory xmlOutputFactory = XMLOutputFactory.newInstance();
    private static final String MAX_PRECISION_PATTERN = "yyyy-MM-dd'T'HH:mm:ss.SSS";
    private static final int MAX_PRECISION_DATESTRING_LENGTH = "yyyy-MM-dd'T'HH:mm:ss.SSS".replaceAll("'", "").length();

    public static StreamMd5AndLength analyzeStream(InputStream sourceStream, long writeLength, long abandonLength, boolean rewindSourceStream, boolean calculateMD5) throws IOException, StorageException {
        if (abandonLength < 0L) {
            abandonLength = Long.MAX_VALUE;
        }
        if (rewindSourceStream) {
            if (!sourceStream.markSupported()) {
                throw new IllegalArgumentException("Input stream must be markable.");
            }
            sourceStream.mark(0x10000000);
        }
        MessageDigest digest = null;
        if (calculateMD5) {
            try {
                digest = MessageDigest.getInstance("MD5");
            }
            catch (NoSuchAlgorithmException e) {
                throw Utility.generateNewUnexpectedStorageException(e);
            }
        }
        if (writeLength < 0L) {
            writeLength = Long.MAX_VALUE;
        }
        StreamMd5AndLength retVal = new StreamMd5AndLength();
        int count = -1;
        byte[] retrievedBuff = new byte[8192];
        int nextCopy = (int)Math.min((long)retrievedBuff.length, writeLength - retVal.getLength());
        count = sourceStream.read(retrievedBuff, 0, nextCopy);
        while (nextCopy > 0 && count != -1) {
            if (calculateMD5) {
                digest.update(retrievedBuff, 0, count);
            }
            retVal.setLength(retVal.getLength() + (long)count);
            if (retVal.getLength() > abandonLength) {
                retVal.setLength(-1L);
                retVal.setMd5(null);
                break;
            }
            nextCopy = (int)Math.min((long)retrievedBuff.length, writeLength - retVal.getLength());
            count = sourceStream.read(retrievedBuff, 0, nextCopy);
        }
        if (retVal.getLength() != -1L && calculateMD5) {
            retVal.setMd5(Base64.encode(digest.digest()));
        }
        if (retVal.getLength() != -1L && writeLength > 0L) {
            retVal.setLength(Math.min(retVal.getLength(), writeLength));
        }
        if (rewindSourceStream) {
            sourceStream.reset();
            sourceStream.mark(0x10000000);
        }
        return retVal;
    }

    public static long encryptStreamIfUnderThreshold(InputStream sourceStream, ByteArrayOutputStream targetStream, Cipher cipher, long writeLength, long abandonLength) throws IOException {
        if (abandonLength < 0L) {
            abandonLength = Long.MAX_VALUE;
        }
        if (!sourceStream.markSupported()) {
            throw new IllegalArgumentException("Input stream must be markable.");
        }
        sourceStream.mark(0x10000000);
        if (writeLength < 0L) {
            writeLength = Long.MAX_VALUE;
        }
        CipherOutputStream encryptStream = new CipherOutputStream(targetStream, cipher);
        int count = -1;
        long totalEncryptedLength = targetStream.size();
        byte[] retrievedBuff = new byte[8192];
        int nextCopy = (int)Math.min((long)retrievedBuff.length, writeLength - totalEncryptedLength);
        count = sourceStream.read(retrievedBuff, 0, nextCopy);
        while (nextCopy > 0 && count != -1) {
            encryptStream.write(retrievedBuff, 0, count);
            encryptStream.flush();
            totalEncryptedLength = targetStream.size();
            if (totalEncryptedLength > abandonLength) break;
            nextCopy = (int)Math.min((long)retrievedBuff.length, writeLength - totalEncryptedLength);
            count = sourceStream.read(retrievedBuff, 0, nextCopy);
        }
        sourceStream.reset();
        sourceStream.mark(0x10000000);
        encryptStream.close();
        totalEncryptedLength = targetStream.size();
        if (totalEncryptedLength > abandonLength) {
            totalEncryptedLength = -1L;
        }
        return totalEncryptedLength;
    }

    public static void assertContinuationType(ResultContinuation continuationToken, ResultContinuationType continuationType) {
        if (continuationToken != null && continuationToken.getContinuationType() != ResultContinuationType.NONE && continuationToken.getContinuationType() != continuationType) {
            String errorMessage = String.format(LOCALE_US, "The continuation type passed in is unexpected. Please verify that the correct continuation type is passed in. Expected {%s}, found {%s}.", new Object[]{continuationType, continuationToken.getContinuationType()});
            throw new IllegalArgumentException(errorMessage);
        }
    }

    public static void assertNotNull(String param, Object value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format(LOCALE_US, "The argument must not be null. Argument name: %s.", param));
        }
    }

    public static void assertNotNullOrEmpty(String param, String value) {
        Utility.assertNotNull(param, value);
        if (Utility.isNullOrEmpty(value)) {
            throw new IllegalArgumentException(String.format(LOCALE_US, "The argument must not be null or an empty string. Argument name: %s.", param));
        }
    }

    public static void assertInBounds(String param, long value, long min, long max) {
        if (value < min || value > max) {
            throw new IllegalArgumentException(String.format("The value of the parameter '%s' should be between %s and %s.", param, min, max));
        }
    }

    public static void assertGreaterThanOrEqual(String param, long value, long min) {
        if (value < min) {
            throw new IllegalArgumentException(String.format("The value of the parameter '%s' should be greater than or equal to %s.", param, min));
        }
    }

    public static byte[] binaryAppend(byte[] arr1, byte[] arr2) {
        byte[] result = new byte[arr1.length + arr2.length];
        System.arraycopy(arr1, 0, result, 0, arr1.length);
        System.arraycopy(arr2, 0, result, arr1.length, arr2.length);
        return result;
    }

    public static boolean validateMaxExecutionTimeout(Long operationExpiryTimeInMs) {
        return Utility.validateMaxExecutionTimeout(operationExpiryTimeInMs, 0L);
    }

    public static boolean validateMaxExecutionTimeout(Long operationExpiryTimeInMs, long additionalInterval) {
        if (operationExpiryTimeInMs != null) {
            long currentTime = new Date().getTime();
            return operationExpiryTimeInMs < currentTime + additionalInterval;
        }
        return false;
    }

    public static int getRemainingTimeout(Long operationExpiryTimeInMs, Integer timeoutIntervalInMs) throws StorageException {
        if (operationExpiryTimeInMs != null) {
            long remainingTime = operationExpiryTimeInMs - new Date().getTime();
            if (remainingTime > Integer.MAX_VALUE) {
                return Integer.MAX_VALUE;
            }
            if (remainingTime > 0L) {
                return (int)remainingTime;
            }
            TimeoutException timeoutException = new TimeoutException("The client could not finish the operation within specified maximum execution timeout.");
            StorageException translatedException = new StorageException("OperationTimedOut", "The client could not finish the operation within specified maximum execution timeout.", 306, null, timeoutException);
            throw translatedException;
        }
        if (timeoutIntervalInMs != null) {
            return timeoutIntervalInMs + 300000;
        }
        return 300000;
    }

    public static boolean determinePathStyleFromUri(URI baseURI) {
        String path = baseURI.getPath();
        if (path != null && path.startsWith("/")) {
            path = path.substring(1);
        }
        if (Utility.isNullOrEmpty(path)) {
            return false;
        }
        return pathStylePorts.contains(baseURI.getPort()) || !Utility.isHostDnsName(baseURI);
    }

    private static boolean isHostDnsName(URI uri) {
        String host = uri.getHost();
        for (int i = 0; i < host.length(); ++i) {
            char hostChar = host.charAt(i);
            if (Character.isDigit(hostChar) || hostChar == '.') continue;
            return true;
        }
        return false;
    }

    public static String formatETag(String etag) {
        if (etag.startsWith("\"") && etag.endsWith("\"")) {
            return etag;
        }
        return String.format("\"%s\"", etag);
    }

    public static StorageException generateNewUnexpectedStorageException(Exception cause) {
        StorageException exceptionRef = new StorageException(StorageErrorCode.NONE.toString(), "Unexpected internal storage client error.", 306, null, null);
        exceptionRef.initCause(cause);
        return exceptionRef;
    }

    public static String getGMTTime() {
        return Utility.getGMTTime(new Date());
    }

    public static String getGMTTime(Date date) {
        return RFC1123_GMT_DATE_TIME_FORMATTER.get().format(date);
    }

    public static String getJavaISO8601Time(Date date) {
        SimpleDateFormat formatter = new SimpleDateFormat(JAVA_ISO8601_PATTERN, LOCALE_US);
        formatter.setTimeZone(UTC_ZONE);
        return formatter.format(date);
    }

    public static JsonGenerator getJsonGenerator(StringWriter strWriter) throws IOException {
        return jsonFactory.createGenerator((Writer)strWriter);
    }

    public static JsonGenerator getJsonGenerator(OutputStream outStream) throws IOException {
        return jsonFactory.createGenerator(outStream);
    }

    public static JsonParser getJsonParser(String jsonString) throws JsonParseException, IOException {
        JsonParser parser = jsonFactory.createParser(jsonString);
        return Utility.setupJsonParser(parser);
    }

    public static JsonParser getJsonParser(InputStream inStream) throws JsonParseException, IOException {
        JsonParser parser = jsonFactory.createParser(inStream);
        return Utility.setupJsonParser(parser);
    }

    private static JsonParser setupJsonParser(JsonParser parser) {
        parser.disable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        return parser.enable(JsonParser.Feature.ALLOW_NON_NUMERIC_NUMBERS);
    }

    public static SAXParser getSAXParser() throws ParserConfigurationException, SAXException {
        SAXParser parser = saxParserThreadLocal.get();
        parser.reset();
        return parser;
    }

    public static String getStandardHeaderValue(HttpURLConnection conn, String headerName) {
        String headerValue = conn.getRequestProperty(headerName);
        return headerValue == null ? "" : headerValue;
    }

    public static String getUTCTimeOrEmpty(Date value) {
        if (value == null) {
            return "";
        }
        SimpleDateFormat iso8601Format = new SimpleDateFormat(ISO8601_PATTERN, LOCALE_US);
        iso8601Format.setTimeZone(UTC_ZONE);
        return iso8601Format.format(value);
    }

    public static XMLStreamWriter createXMLStreamWriter(StringWriter outWriter) throws XMLStreamException {
        return xmlOutputFactory.createXMLStreamWriter(outWriter);
    }

    public static IOException initIOException(Exception ex) {
        String message = null;
        message = ex != null && ex.getMessage() != null ? ex.getMessage() + " Please see the cause for further information." : "Please see the cause for further information.";
        IOException retEx = new IOException(message, ex);
        return retEx;
    }

    public static boolean isNullOrEmpty(String value) {
        return value == null || value.length() == 0;
    }

    public static boolean isNullOrEmptyOrWhitespace(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static HashMap<String, String> parseAccountString(String parseString) {
        String[] valuePairs = parseString.split(";");
        HashMap<String, String> retVals = new HashMap<String, String>();
        for (int m = 0; m < valuePairs.length; ++m) {
            if (valuePairs[m].length() == 0) continue;
            int equalDex = valuePairs[m].indexOf("=");
            if (equalDex < 1) {
                throw new IllegalArgumentException("Invalid connection string.");
            }
            String key = valuePairs[m].substring(0, equalDex);
            String value = valuePairs[m].substring(equalDex + 1);
            retVals.put(key, value);
        }
        return retVals;
    }

    public static Date parseRFC1123DateFromStringInGMT(String value) throws ParseException {
        return RFC1123_GMT_DATE_TIME_FORMATTER.get().parse(value);
    }

    public static String safeDecode(String stringToDecode) throws StorageException {
        if (stringToDecode == null) {
            return null;
        }
        if (stringToDecode.length() == 0) {
            return "";
        }
        try {
            if (stringToDecode.contains("+")) {
                StringBuilder outBuilder = new StringBuilder();
                int startDex = 0;
                for (int m = 0; m < stringToDecode.length(); ++m) {
                    if (stringToDecode.charAt(m) != '+') continue;
                    if (m > startDex) {
                        outBuilder.append(URLDecoder.decode(stringToDecode.substring(startDex, m), "UTF-8"));
                    }
                    outBuilder.append("+");
                    startDex = m + 1;
                }
                if (startDex != stringToDecode.length()) {
                    outBuilder.append(URLDecoder.decode(stringToDecode.substring(startDex, stringToDecode.length()), "UTF-8"));
                }
                return outBuilder.toString();
            }
            return URLDecoder.decode(stringToDecode, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }

    public static String safeEncode(String stringToEncode) throws StorageException {
        if (stringToEncode == null) {
            return null;
        }
        if (stringToEncode.length() == 0) {
            return "";
        }
        try {
            String tString = URLEncoder.encode(stringToEncode, "UTF-8");
            if (stringToEncode.contains(" ")) {
                StringBuilder outBuilder = new StringBuilder();
                int startDex = 0;
                for (int m = 0; m < stringToEncode.length(); ++m) {
                    if (stringToEncode.charAt(m) != ' ') continue;
                    if (m > startDex) {
                        outBuilder.append(URLEncoder.encode(stringToEncode.substring(startDex, m), "UTF-8"));
                    }
                    outBuilder.append("%20");
                    startDex = m + 1;
                }
                if (startDex != stringToEncode.length()) {
                    outBuilder.append(URLEncoder.encode(stringToEncode.substring(startDex, stringToEncode.length()), "UTF-8"));
                }
                return outBuilder.toString();
            }
            return tString;
        }
        catch (UnsupportedEncodingException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }

    public static String safeRelativize(URI baseURI, URI toUri) throws URISyntaxException {
        int m;
        if (!baseURI.getHost().equals(toUri.getHost()) || !baseURI.getScheme().equals(toUri.getScheme())) {
            return toUri.toString();
        }
        String basePath = baseURI.getPath();
        String toPath = toUri.getPath();
        int truncatePtr = 1;
        int ellipsesCount = 0;
        for (m = 0; m < basePath.length(); ++m) {
            if (m >= toPath.length()) {
                if (basePath.charAt(m) != '/') continue;
                ++ellipsesCount;
                continue;
            }
            if (basePath.charAt(m) != toPath.charAt(m)) break;
            if (basePath.charAt(m) != '/') continue;
            truncatePtr = m + 1;
        }
        if (m < toPath.length() && toPath.charAt(m) == '/' && (toPath.charAt(m - 1) != '/' || basePath.charAt(m - 1) != '/')) {
            truncatePtr = m + 1;
        }
        if (m == toPath.length()) {
            return new URI(null, null, null, toUri.getQuery(), toUri.getFragment()).toString();
        }
        toPath = toPath.substring(truncatePtr);
        StringBuilder sb = new StringBuilder();
        while (ellipsesCount > 0) {
            sb.append("../");
            --ellipsesCount;
        }
        if (!Utility.isNullOrEmpty(toPath)) {
            sb.append(toPath);
        }
        if (!Utility.isNullOrEmpty(toUri.getQuery())) {
            sb.append("?");
            sb.append(toUri.getQuery());
        }
        if (!Utility.isNullOrEmpty(toUri.getFragment())) {
            sb.append("#");
            sb.append(toUri.getRawFragment());
        }
        return sb.toString();
    }

    public static void logHttpError(StorageException ex, OperationContext opContext) {
        if (Logger.shouldLog(opContext)) {
            try {
                StringBuilder bld = new StringBuilder();
                bld.append("Error response received. ");
                bld.append("HttpStatusCode= ");
                bld.append(ex.getHttpStatusCode());
                bld.append(", HttpStatusMessage= ");
                bld.append(ex.getMessage());
                bld.append(", ErrorCode= ");
                bld.append(ex.getErrorCode());
                StorageExtendedErrorInformation extendedError = ex.getExtendedErrorInformation();
                if (extendedError != null) {
                    bld.append(", ExtendedErrorInformation= {ErrorMessage= ");
                    bld.append(extendedError.getErrorMessage());
                    HashMap<String, String[]> details = extendedError.getAdditionalDetails();
                    if (details != null) {
                        bld.append(", AdditionalDetails= { ");
                        for (Map.Entry<String, String[]> detail : details.entrySet()) {
                            bld.append(detail.getKey());
                            bld.append("= ");
                            for (String value : detail.getValue()) {
                                bld.append(value);
                            }
                            bld.append(",");
                        }
                        bld.setCharAt(bld.length() - 1, '}');
                    }
                    bld.append("}");
                }
                Logger.debug(opContext, bld.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void logHttpRequest(HttpURLConnection conn, OperationContext opContext) throws IOException {
        if (Logger.shouldLog(opContext)) {
            try {
                StringBuilder bld = new StringBuilder();
                bld.append(conn.getRequestMethod());
                bld.append(" ");
                bld.append(conn.getURL());
                bld.append("\n");
                for (Map.Entry<String, List<String>> header : conn.getRequestProperties().entrySet()) {
                    if (header.getKey() != null) {
                        bld.append(header.getKey());
                        bld.append(": ");
                    }
                    for (int i = 0; i < header.getValue().size(); ++i) {
                        bld.append(header.getValue().get(i));
                        if (i >= header.getValue().size() - 1) continue;
                        bld.append(",");
                    }
                    bld.append('\n');
                }
                Logger.trace(opContext, bld.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void logHttpResponse(HttpURLConnection conn, OperationContext opContext) throws IOException {
        if (Logger.shouldLog(opContext)) {
            try {
                StringBuilder bld = new StringBuilder();
                for (Map.Entry<String, List<String>> header : conn.getHeaderFields().entrySet()) {
                    if (header.getKey() != null) {
                        bld.append(header.getKey());
                        bld.append(": ");
                    }
                    for (int i = 0; i < header.getValue().size(); ++i) {
                        bld.append(header.getValue().get(i));
                        if (i >= header.getValue().size() - 1) continue;
                        bld.append(",");
                    }
                    bld.append('\n');
                }
                Logger.trace(opContext, bld.toString());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    protected static String trimEnd(String value, char trimChar) {
        int stopDex;
        for (stopDex = value.length() - 1; stopDex > 0 && value.charAt(stopDex) == trimChar; --stopDex) {
        }
        return stopDex == value.length() - 1 ? value : value.substring(stopDex);
    }

    public static String trimStart(String value) {
        int spaceDex;
        for (spaceDex = 0; spaceDex < value.length() && value.charAt(spaceDex) == ' '; ++spaceDex) {
        }
        return value.substring(spaceDex);
    }

    public static StreamMd5AndLength writeToOutputStream(InputStream sourceStream, OutputStream outStream, long writeLength, boolean rewindSourceStream, boolean calculateMD5, OperationContext opContext, RequestOptions options) throws IOException, StorageException {
        return Utility.writeToOutputStream(sourceStream, outStream, writeLength, rewindSourceStream, calculateMD5, opContext, options, true);
    }

    public static StreamMd5AndLength writeToOutputStream(InputStream sourceStream, OutputStream outStream, long writeLength, boolean rewindSourceStream, boolean calculateMD5, OperationContext opContext, RequestOptions options, Boolean shouldFlush) throws IOException, StorageException {
        return Utility.writeToOutputStream(sourceStream, outStream, writeLength, rewindSourceStream, calculateMD5, opContext, options, shouldFlush, null, null);
    }

    public static StreamMd5AndLength writeToOutputStream(InputStream sourceStream, OutputStream outStream, long writeLength, boolean rewindSourceStream, boolean calculateMD5, OperationContext opContext, RequestOptions options, Boolean shouldFlush, StorageRequest<?, ?, Integer> request, StreamMd5AndLength descriptor) throws IOException, StorageException {
        if (rewindSourceStream && sourceStream.markSupported()) {
            sourceStream.reset();
            sourceStream.mark(0x10000000);
        }
        if (descriptor == null) {
            descriptor = new StreamMd5AndLength();
            if (calculateMD5) {
                try {
                    descriptor.setDigest(MessageDigest.getInstance("MD5"));
                }
                catch (NoSuchAlgorithmException e) {
                    throw Utility.generateNewUnexpectedStorageException(e);
                }
            }
        } else {
            descriptor.setMd5(null);
        }
        if (writeLength < 0L) {
            writeLength = Long.MAX_VALUE;
        }
        byte[] retrievedBuff = new byte[8192];
        int nextCopy = (int)Math.min((long)retrievedBuff.length, writeLength);
        int count = sourceStream.read(retrievedBuff, 0, nextCopy);
        while (nextCopy > 0 && count != -1) {
            if (Utility.validateMaxExecutionTimeout(options.getOperationExpiryTimeInMs())) {
                TimeoutException timeoutException = new TimeoutException("The client could not finish the operation within specified maximum execution timeout.");
                throw Utility.initIOException(timeoutException);
            }
            if (outStream != null) {
                outStream.write(retrievedBuff, 0, count);
            }
            if (calculateMD5) {
                descriptor.getDigest().update(retrievedBuff, 0, count);
            }
            descriptor.setLength(descriptor.getLength() + (long)count);
            descriptor.setCurrentOperationByteCount(descriptor.getCurrentOperationByteCount() + (long)count);
            if (request != null) {
                request.setCurrentRequestByteCount(request.getCurrentRequestByteCount() + (long)count);
                request.setCurrentDescriptor(descriptor);
            }
            nextCopy = (int)Math.min((long)retrievedBuff.length, writeLength - descriptor.getLength());
            count = sourceStream.read(retrievedBuff, 0, nextCopy);
        }
        if (outStream != null && shouldFlush.booleanValue()) {
            outStream.flush();
        }
        return descriptor;
    }

    private Utility() {
    }

    public static void checkNullaryCtor(Class<?> clazzType) {
        Constructor<?> ctor = null;
        try {
            ctor = clazzType.getDeclaredConstructor(null);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Class type must contain contain a nullary constructor.");
        }
        if (ctor == null) {
            throw new IllegalArgumentException("Class type must contain contain a nullary constructor.");
        }
    }

    public static Date parseDate(String dateString) {
        String pattern = MAX_PRECISION_PATTERN;
        switch (dateString.length()) {
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                dateString = dateString.substring(0, MAX_PRECISION_DATESTRING_LENGTH);
                break;
            }
            case 23: {
                dateString = dateString.replace("Z", "0");
                break;
            }
            case 22: {
                dateString = dateString.replace("Z", "00");
                break;
            }
            case 20: {
                pattern = ISO8601_PATTERN;
                break;
            }
            case 17: {
                pattern = ISO8601_PATTERN_NO_SECONDS;
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format("Invalid Date String: %s.", dateString));
            }
        }
        SimpleDateFormat format = new SimpleDateFormat(pattern, LOCALE_US);
        format.setTimeZone(UTC_ZONE);
        try {
            return format.parse(dateString);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(String.format("Invalid Date String: %s.", dateString), e);
        }
    }

    public static Date parseDate(String dateString, boolean dateBackwardCompatibility) {
        if (!dateBackwardCompatibility) {
            return Utility.parseDate(dateString);
        }
        int beginMilliIndex = 20;
        int endTenthMilliIndex = 24;
        if (dateString.length() > 24 && "0000".equals(dateString.substring(20, 24))) {
            dateString = dateString.substring(0, 20) + dateString.substring(24);
        }
        return Utility.parseDate(dateString);
    }

    public static RequestLocationMode getListingLocationMode(ResultContinuation token) {
        if (token != null && token.getTargetLocation() != null) {
            switch (token.getTargetLocation()) {
                case PRIMARY: {
                    return RequestLocationMode.PRIMARY_ONLY;
                }
                case SECONDARY: {
                    return RequestLocationMode.SECONDARY_ONLY;
                }
            }
            throw new IllegalArgumentException(String.format("The argument is out of range. Argument name: %s, Value passed: %s.", new Object[]{"token", token.getTargetLocation()}));
        }
        return RequestLocationMode.PRIMARY_OR_SECONDARY;
    }

    public static String stringJoin(CharSequence delimiter, final String ... strings) {
        return Utility.stringJoin(delimiter, new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return new Iterator<String>(){
                    private final String[] internalArray;
                    private int index;
                    {
                        this.internalArray = strings;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.internalArray.length > this.index;
                    }

                    @Override
                    public String next() {
                        return this.internalArray[this.index++];
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        });
    }

    public static String stringJoin(CharSequence delimiter, Iterable<String> strings) {
        StringBuilder sb = new StringBuilder();
        Iterator<String> iterator = strings.iterator();
        if (iterator.hasNext()) {
            sb.append(iterator.next());
        }
        while (iterator.hasNext()) {
            sb.append(delimiter);
            sb.append(iterator.next());
        }
        return sb.toString();
    }

    public static List<byte[]> splitOnPattern(byte[] array, byte[] pattern) {
        List<Integer> sortedPatternIndices = Utility.findAllPatternOccurences(array, pattern);
        ArrayList<byte[]> tokens = new ArrayList<byte[]>(sortedPatternIndices.size() + 1);
        int nextTokenStart = 0;
        for (int patternStart : sortedPatternIndices) {
            if (patternStart - 1 > nextTokenStart) {
                tokens.add(Arrays.copyOfRange(array, nextTokenStart, patternStart));
            }
            nextTokenStart = patternStart + pattern.length;
        }
        if (nextTokenStart < array.length - 1) {
            tokens.add(Arrays.copyOfRange(array, nextTokenStart, array.length));
        }
        return tokens;
    }

    public static List<Integer> findAllPatternOccurences(byte[] array, byte[] pattern) {
        int result;
        ArrayList<Integer> indices = new ArrayList<Integer>();
        int offset = 0;
        while ((result = Utility.findPattern(array, pattern, offset)) != -1) {
            indices.add(result);
            offset = result + pattern.length;
            if (offset <= array.length - pattern.length + 1) continue;
            break;
        }
        return indices;
    }

    public static int findPattern(byte[] array, byte[] pattern, int scanOffset) {
        for (int i = scanOffset; i < array.length - pattern.length + 1; ++i) {
            if (!Utility.isMatch(array, pattern, i)) continue;
            return i;
        }
        return -1;
    }

    private static boolean isMatch(byte[] array, byte[] pattern, int arrayPos) {
        for (int i = 0; i < pattern.length; ++i) {
            if (pattern[i] == array[arrayPos + i]) continue;
            return false;
        }
        return true;
    }
}

