/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Logging;
import ch.cyberduck.core.logging.LoggingConfiguration;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.apache.log4j.Logger;

public class WriteLoggingWorker
extends Worker<Boolean> {
    private static final Logger log = Logger.getLogger(WriteLoggingWorker.class);
    private final List<Path> files;
    private final LoggingConfiguration configuration;

    public WriteLoggingWorker(List<Path> files, LoggingConfiguration configuration) {
        this.files = files;
        this.configuration = configuration;
    }

    @Override
    public Boolean run(Session<?> session) throws BackgroundException {
        Logging feature = session.getFeature(Logging.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Run with feature %s", feature));
        }
        for (Path file : this.getContainers(this.files)) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            this.write(feature, file);
        }
        return true;
    }

    private void write(Logging feature, Path file) throws BackgroundException {
        feature.setConfiguration(file, this.configuration);
    }

    @Override
    public Boolean initialize() {
        return false;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Writing metadata of {0}", "Status"), this.toString(this.files));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WriteLoggingWorker that = (WriteLoggingWorker)o;
        return Objects.equals(this.files, that.files);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WriteLoggingConfigurationWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

