/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.MappingMimeTypeService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AclPermission;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;
import java.util.EnumSet;
import java.util.Objects;
import org.apache.log4j.Logger;

public class TouchWorker
extends Worker<Path> {
    private static final Logger log = Logger.getLogger(TouchWorker.class);
    private final Path file;

    public TouchWorker(Path file) {
        this.file = file;
    }

    @Override
    public Path run(Session<?> session) throws BackgroundException {
        Redundancy redundancy;
        Touch feature = session.getFeature(Touch.class);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Run with feature %s", feature));
        }
        TransferStatus status = new TransferStatus().exists(false).length(0L).withMime(new MappingMimeTypeService().getMime(this.file.getName()));
        Encryption encryption = session.getFeature(Encryption.class);
        if (encryption != null) {
            status.setEncryption(encryption.getDefault(this.file));
        }
        if ((redundancy = session.getFeature(Redundancy.class)) != null) {
            status.setStorageClass(redundancy.getDefault());
        }
        status.setTimestamp(System.currentTimeMillis());
        if (PreferencesFactory.get().getBoolean("touch.permissions.change")) {
            AclPermission acl;
            UnixPermission permission = session.getFeature(UnixPermission.class);
            if (permission != null) {
                status.setPermission(permission.getDefault(EnumSet.of(AbstractPath.Type.file)));
            }
            if ((acl = session.getFeature(AclPermission.class)) != null) {
                status.setAcl(acl.getDefault(EnumSet.of(AbstractPath.Type.file)));
            }
        }
        return feature.touch(this.file, status);
    }

    @Override
    public Path initialize() {
        return this.file;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Uploading {0}", "Status"), this.file.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TouchWorker that = (TouchWorker)o;
        return Objects.equals(this.file, that.file);
    }

    public int hashCode() {
        return this.file != null ? this.file.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("TouchWorker{");
        sb.append("file=").append(this.file);
        sb.append('}');
        return sb.toString();
    }
}

