/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.updater;

import ch.cyberduck.core.Controller;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.threading.DefaultMainAction;
import ch.cyberduck.core.updater.PeriodicUpdateChecker;
import ch.cyberduck.core.updater.UpdateCheckerArguments;
import ch.cyberduck.core.updater.UpdateCheckerArgumentsFactory;
import java.time.Duration;
import java.util.Map;
import java.util.Timer;
import java.util.TimerTask;
import org.apache.log4j.Logger;

public abstract class AbstractPeriodicUpdateChecker
implements PeriodicUpdateChecker {
    private static final Logger log = Logger.getLogger((String)AbstractPeriodicUpdateChecker.class.getName());
    private final Controller controller;
    private final Duration delay;
    private final Timer timer = new Timer("updater", true);
    private final Preferences preferences = PreferencesFactory.get();

    public AbstractPeriodicUpdateChecker(Controller controller) {
        this(controller, Duration.ofSeconds(PreferencesFactory.get().getLong("update.check.interval")));
    }

    public AbstractPeriodicUpdateChecker(Controller controller, Duration delay) {
        this.controller = controller;
        this.delay = delay;
    }

    @Override
    public void unregister() {
        this.timer.cancel();
    }

    @Override
    public Duration register() {
        log.info((Object)String.format("Register update checker hook after %s", this.delay));
        try {
            this.timer.scheduleAtFixedRate(new TimerTask(){

                @Override
                public void run() {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)String.format("Check for new updates after %s", AbstractPeriodicUpdateChecker.this.delay));
                    }
                    PreferencesFactory.get().setProperty("update.check.timestamp", System.currentTimeMillis());
                    AbstractPeriodicUpdateChecker.this.controller.invoke(new DefaultMainAction(){

                        @Override
                        public void run() {
                            AbstractPeriodicUpdateChecker.this.check(true);
                        }
                    });
                }
            }, this.delay.toMillis(), this.delay.toMillis());
            return this.delay;
        }
        catch (IllegalStateException e) {
            log.warn((Object)String.format("Failure scheduling timer. %s", e.getMessage()));
            return Duration.ZERO;
        }
    }

    @Override
    public boolean hasUpdatePrivileges() {
        return true;
    }

    @Override
    public boolean isUpdateInProgress() {
        return false;
    }

    protected String getFeedUrl() {
        StringBuilder url = new StringBuilder(this.preferences.getProperty(String.format("update.feed.%s", this.preferences.getProperty("update.feed"))));
        UpdateCheckerArguments arguments = UpdateCheckerArgumentsFactory.get();
        Map<String, String> set = arguments.build();
        if (!set.isEmpty()) {
            url.append("?");
        }
        for (Map.Entry<String, String> arg : set.entrySet()) {
            if (!url.toString().endsWith("?")) {
                url.append("&");
            }
            url.append(URIEncoder.encode(arg.getKey())).append("=").append(URIEncoder.encode(arg.getValue()));
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Setting update feed to %s", url));
        }
        return url.toString();
    }
}

