/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.normalizer;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.normalizer.RootPathsNormalizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Logger;

public class UploadRootPathsNormalizer
implements RootPathsNormalizer<List<TransferItem>> {
    private static final Logger log = Logger.getLogger(UploadRootPathsNormalizer.class);

    @Override
    public List<TransferItem> normalize(List<TransferItem> roots) {
        ArrayList<TransferItem> normalized = new ArrayList<TransferItem>();
        for (TransferItem upload : roots) {
            boolean duplicate = false;
            Iterator iter = normalized.iterator();
            while (iter.hasNext()) {
                TransferItem n = (TransferItem)iter.next();
                if (upload.local.isChild(n.local)) {
                    duplicate = true;
                    break;
                }
                if (n.local.isChild(upload.local)) {
                    iter.remove();
                }
                if (!upload.remote.equals(n.remote)) continue;
                Path parent = upload.remote.getParent();
                String filename = upload.remote.getName();
                int no = 0;
                int index = filename.lastIndexOf(46);
                String proposal = index != -1 && index != 0 ? String.format("%s-%d%s", filename.substring(0, index), ++no, filename.substring(index)) : String.format("%s-%d", filename, ++no);
                Path remote = new Path(parent, proposal, upload.remote.getType());
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Changed name from %s to %s", filename, remote.getName()));
                }
                upload.remote = remote;
            }
            if (duplicate) continue;
            normalized.add(new TransferItem(upload.remote, upload.local, upload.lockId));
        }
        return normalized;
    }
}

