/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer.normalizer;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.transfer.TransferItem;
import ch.cyberduck.core.transfer.normalizer.RootPathsNormalizer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class DownloadRootPathsNormalizer
implements RootPathsNormalizer<List<TransferItem>> {
    private static final Logger log = Logger.getLogger(DownloadRootPathsNormalizer.class);

    @Override
    public List<TransferItem> normalize(List<TransferItem> roots) {
        ArrayList<TransferItem> normalized = new ArrayList<TransferItem>();
        for (TransferItem download : roots) {
            boolean duplicate = false;
            Iterator iter = normalized.iterator();
            while (iter.hasNext()) {
                String proposal;
                Local local;
                TransferItem n = (TransferItem)iter.next();
                if (download.remote.isChild(n.remote)) {
                    duplicate = true;
                    break;
                }
                if (n.remote.isChild(download.remote)) {
                    iter.remove();
                }
                if (!download.local.equals(n.local)) continue;
                String parent = download.local.getParent().getAbsolute();
                String filename = download.remote.getName();
                int no = 0;
                do {
                    proposal = String.format("%s-%d", FilenameUtils.getBaseName((String)filename), ++no);
                    if (!StringUtils.isNotBlank((CharSequence)FilenameUtils.getExtension((String)filename))) continue;
                    proposal = proposal + String.format(".%s", FilenameUtils.getExtension((String)filename));
                } while ((local = LocalFactory.get(parent, proposal)).exists());
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Changed local name from %s to %s", filename, local.getName()));
                }
                download.local = local;
            }
            if (duplicate) continue;
            normalized.add(new TransferItem(download.remote, download.local, download.lockId));
        }
        return normalized;
    }
}

