/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.ssl;

import ch.cyberduck.core.CertificateStore;
import ch.cyberduck.core.CertificateStoreFactory;
import ch.cyberduck.core.Controller;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.ssl.CertificateStoreX509KeyManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import java.net.Socket;
import java.security.KeyStore;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class KeychainX509KeyManager
extends CertificateStoreX509KeyManager
implements X509KeyManager {
    private final Map<Key, String> memory = new HashMap<Key, String>();
    private final Set<String> aliases = new HashSet<String>();

    public KeychainX509KeyManager(Host bookmark) {
        super(CertificateStoreFactory.get(), bookmark);
    }

    public KeychainX509KeyManager(Host bookmark, Controller controller) {
        super(CertificateStoreFactory.get(controller), bookmark);
    }

    public KeychainX509KeyManager(Host bookmark, CertificateStore callback) {
        super(callback, bookmark);
    }

    public KeychainX509KeyManager(Host bookmark, CertificateStore callback, KeyStore store) {
        super(bookmark, callback, store);
    }

    @Override
    public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
        Key key = new Key(socket.getInetAddress().getHostName(), socket.getPort(), issuers);
        String alias = this.find(key);
        if (alias != null) {
            return alias;
        }
        String s = super.chooseClientAlias(keyTypes, issuers, socket);
        if (null == s) {
            return null;
        }
        return this.save(key, s);
    }

    @Override
    public List<String> list() {
        if (this.aliases.isEmpty()) {
            this.aliases.addAll(super.list());
        }
        return new ArrayList<String>(this.aliases);
    }

    protected String find(Key key) {
        if (this.memory.containsKey(key)) {
            return this.memory.get(key);
        }
        return null;
    }

    protected String save(Key key, String alias) {
        this.memory.put(key, alias);
        return alias;
    }

    protected static final class Key {
        private final String hostname;
        private final int port;
        private final Principal[] issuers;

        private Key(String hostname, int port, Principal[] issuers) {
            this.hostname = hostname;
            this.port = port;
            this.issuers = issuers;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Key key = (Key)o;
            if (this.port != key.port) {
                return false;
            }
            if (!Objects.equals(this.hostname, key.hostname)) {
                return false;
            }
            return Arrays.equals(this.issuers, key.issuers);
        }

        public int hashCode() {
            int result = this.hostname != null ? this.hostname.hashCode() : 0;
            result = 31 * result + this.port;
            result = 31 * result + (this.issuers != null ? Arrays.hashCode(this.issuers) : 0);
            return result;
        }

        public String toString() {
            return String.format("connection.ssl.keystore.%s:%s.%s.alias", this.hostname, this.port, Arrays.toString(this.issuers));
        }
    }
}

