/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.serializer.Deserializer;
import ch.cyberduck.core.serializer.LocalDictionary;
import ch.cyberduck.core.serializer.PathDictionary;
import ch.cyberduck.core.transfer.TransferItem;

public class TransferItemDictionary {
    private final DeserializerFactory deserializer;

    public TransferItemDictionary() {
        this.deserializer = new DeserializerFactory();
    }

    public TransferItemDictionary(DeserializerFactory deserializer) {
        this.deserializer = deserializer;
    }

    public <T> TransferItem deserialize(T serialized) {
        Object lockObj;
        Deserializer dict = this.deserializer.create(serialized);
        Path remote = new PathDictionary(this.deserializer).deserialize(dict.objectForKey("Remote"));
        if (null == remote) {
            return null;
        }
        TransferItem item = new TransferItem(remote);
        Object localObj = dict.objectForKey("Local Dictionary");
        if (localObj != null) {
            item.setLocal(new LocalDictionary(this.deserializer).deserialize(localObj));
        }
        if ((lockObj = dict.objectForKey("Lock Id")) != null) {
            item.setLockId(lockObj.toString());
        }
        return item;
    }
}

