/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.serializer;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.DeserializerFactory;
import ch.cyberduck.core.serializer.Deserializer;
import java.util.List;

public class AclDictionary {
    private final DeserializerFactory deserializer;

    public AclDictionary() {
        this.deserializer = new DeserializerFactory();
    }

    public AclDictionary(DeserializerFactory deserializer) {
        this.deserializer = deserializer;
    }

    public <T> Acl deserialize(T serialized) {
        Deserializer dict = this.deserializer.create(serialized);
        Acl acl = new Acl();
        List<String> keys = dict.keys();
        for (String key : keys) {
            List rolesObj = dict.listForKey(key);
            for (Object roleObj : rolesObj) {
                Acl.Role role = new Acl.RoleDictionary(this.deserializer).deserialize(roleObj);
                acl.addAll(new Acl.CanonicalUser(key), role);
            }
        }
        return acl;
    }
}

