/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.io.watchservice;

import ch.cyberduck.core.io.watchservice.AbstractWatchKey;
import ch.cyberduck.core.io.watchservice.RegisterWatchService;
import java.io.IOException;
import java.nio.file.ClosedWatchServiceException;
import java.nio.file.WatchKey;
import java.nio.file.Watchable;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;

public abstract class AbstractWatchService
implements RegisterWatchService {
    private final LinkedBlockingDeque<WatchKey> pendingKeys = new LinkedBlockingDeque();
    private final WatchKey CLOSE_KEY = new AbstractWatchKey(null){

        @Override
        public boolean isValid() {
            return true;
        }

        @Override
        public void cancel() {
        }

        @Override
        public Watchable watchable() {
            return null;
        }
    };
    private volatile boolean closed;
    private final Object closeLock = new Object();

    protected AbstractWatchService() {
    }

    final void enqueueKey(WatchKey key) {
        this.pendingKeys.offer(key);
    }

    private void checkOpen() {
        if (this.closed) {
            throw new ClosedWatchServiceException();
        }
    }

    private void checkKey(WatchKey key) {
        if (this.CLOSE_KEY.equals(key)) {
            this.enqueueKey(key);
        }
        this.checkOpen();
    }

    @Override
    public final WatchKey poll() {
        this.checkOpen();
        WatchKey key = this.pendingKeys.poll();
        this.checkKey(key);
        return key;
    }

    @Override
    public final WatchKey poll(long timeout, TimeUnit unit) throws InterruptedException {
        this.checkOpen();
        WatchKey key = this.pendingKeys.poll(timeout, unit);
        this.checkKey(key);
        return key;
    }

    @Override
    public final WatchKey take() throws InterruptedException {
        this.checkOpen();
        WatchKey key = this.pendingKeys.take();
        this.checkKey(key);
        return key;
    }

    final boolean isOpen() {
        return !this.closed;
    }

    final Object closeLock() {
        return this.closeLock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final void close() throws IOException {
        Object object = this.closeLock;
        synchronized (object) {
            if (this.closed) {
                return;
            }
            this.closed = true;
            this.release();
            this.pendingKeys.clear();
            this.pendingKeys.offer(this.CLOSE_KEY);
        }
    }
}

