/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Collection;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.TransferReaderFactory;
import ch.cyberduck.core.TransferWriterFactory;
import ch.cyberduck.core.UUIDRandomStringService;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.formatter.SizeFormatter;
import ch.cyberduck.core.formatter.SizeFormatterFactory;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import ch.cyberduck.core.serializer.Reader;
import ch.cyberduck.core.serializer.Writer;
import ch.cyberduck.core.transfer.Transfer;
import ch.cyberduck.core.transfer.TransferProgress;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.regex.Pattern;
import org.apache.log4j.Logger;

public class FolderTransferCollection
extends Collection<Transfer> {
    private static final Logger log = Logger.getLogger(FolderTransferCollection.class);
    private static final FolderTransferCollection TRANSFER_COLLECTION = new FolderTransferCollection(LocalFactory.get(SupportDirectoryFinderFactory.get().find(), "Transfers"));
    private static final long serialVersionUID = -8276371611952331966L;
    private static final String DEFAULT_PREFIX = "transfer";
    private final Writer<Transfer> writer = TransferWriterFactory.get();
    private final Reader<Transfer> reader = TransferReaderFactory.get();
    private final String prefix;
    private final SizeFormatter sizeFormatter = SizeFormatterFactory.get();
    private final Preferences preferences = PreferencesFactory.get();
    private final Local folder;

    public static FolderTransferCollection defaultCollection() {
        return TRANSFER_COLLECTION;
    }

    public FolderTransferCollection(Local folder) {
        this(folder, DEFAULT_PREFIX);
    }

    public FolderTransferCollection(Local folder, String prefix) {
        this.folder = folder;
        this.prefix = String.format("%s.", prefix);
    }

    public Local getFile(Transfer transfer) {
        return LocalFactory.get(this.folder, String.format("%s.cyberducktransfer", transfer.getUuid()));
    }

    public Local getFolder() {
        return this.folder;
    }

    @Override
    public void collectionItemRemoved(Transfer transfer) {
        try {
            this.getFile(transfer).delete();
            this.preferences.deleteProperty(String.format("%s%s", this.prefix, transfer.getUuid()));
        }
        catch (AccessDeniedException | NotfoundException e) {
            log.error((Object)String.format("Failure removing transfer %s", e.getMessage()));
        }
        finally {
            super.collectionItemRemoved(transfer);
        }
    }

    @Override
    public void collectionItemChanged(Transfer transfer) {
        try {
            this.save(transfer);
        }
        finally {
            super.collectionItemChanged(transfer);
        }
    }

    @Override
    public void collectionItemAdded(Transfer transfer) {
        try {
            this.save(transfer);
            if (this.isLocked()) {
                log.debug((Object)"Skip indexing collection while loading");
            } else {
                this.index();
            }
        }
        finally {
            super.collectionItemAdded(transfer);
        }
    }

    protected void save(Transfer transfer) {
        if (this.isLocked()) {
            log.debug((Object)String.format("Skip saving transfer %s while loading", transfer));
        } else {
            this.lock();
            try {
                if (!this.folder.exists()) {
                    new DefaultLocalDirectoryFeature().mkdir(this.folder);
                }
                Local f = this.getFile(transfer);
                if (log.isInfoEnabled()) {
                    log.info((Object)String.format("Save transfer %s", f));
                }
                this.writer.write(transfer, f);
            }
            catch (AccessDeniedException e) {
                log.warn((Object)String.format("Failure saving item in collection %s", e.getMessage()));
            }
            finally {
                this.unlock();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() throws AccessDeniedException {
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Reloading %s", this.folder.getAbsolute()));
        }
        this.lock();
        try {
            if (!this.folder.exists()) {
                new DefaultLocalDirectoryFeature().mkdir(this.folder);
            }
            AttributedList<Local> transfers = this.folder.list().filter(new Filter<Local>(){

                @Override
                public boolean accept(Local file) {
                    return file.getName().endsWith(".cyberducktransfer");
                }

                @Override
                public Pattern toPattern() {
                    return Pattern.compile(".*\\.cyberducktransfer");
                }
            });
            for (Local f : transfers) {
                try {
                    Transfer transfer = this.reader.read(f);
                    if (!this.getFile(transfer).equals(f)) {
                        this.rename(f, transfer);
                    }
                    this.add(transfer);
                }
                catch (AccessDeniedException e) {
                    log.error((Object)String.format("Failure reading transfer from %s. %s", f, e.getMessage()));
                }
            }
            this.sort();
        }
        finally {
            this.unlock();
        }
        super.load();
    }

    protected void rename(Local next, Transfer transfer) throws AccessDeniedException {
        next.rename(this.getFile(transfer));
    }

    @Override
    public boolean addAll(java.util.Collection<? extends Transfer> c) {
        ArrayList<Transfer> temporary = new ArrayList<Transfer>();
        for (Transfer transfer : c) {
            if (temporary.contains(transfer)) {
                log.warn((Object)String.format("Reset UUID of duplicate in collection for %s", transfer));
                transfer.setUuid(new UUIDRandomStringService().random());
            }
            temporary.add(transfer);
        }
        return super.addAll(temporary);
    }

    private void index() {
        this.lock();
        try {
            for (int i = 0; i < this.size(); ++i) {
                this.preferences.setProperty(String.format("%s%s", this.prefix, ((Transfer)this.get(i)).getUuid()), i);
            }
        }
        finally {
            this.unlock();
        }
    }

    public void save() {
        this.index();
    }

    protected void load(Collection<Transfer> c) {
        this.addAll((java.util.Collection<? extends Transfer>)c);
        this.index();
        this.sort();
        for (Transfer transfer : this) {
            this.save(transfer);
        }
        this.collectionLoaded();
    }

    protected synchronized void sort() {
        Collections.sort(this, new Comparator<Transfer>(){

            @Override
            public int compare(Transfer o1, Transfer o2) {
                return Integer.compare(FolderTransferCollection.this.preferences.getInteger(String.format("%s%s", FolderTransferCollection.this.prefix, o1.getUuid())), FolderTransferCollection.this.preferences.getInteger(String.format("%s%s", FolderTransferCollection.this.prefix, o2.getUuid())));
            }
        });
    }

    public synchronized int numberOfRunningTransfers() {
        int running = 0;
        for (Transfer t : this) {
            if (!t.isRunning()) continue;
            ++running;
        }
        return running;
    }

    public synchronized TransferProgress getProgress() {
        long size = 0L;
        for (Transfer t : this) {
            if (!t.isRunning()) continue;
            size += t.getSize().longValue();
        }
        long transferred = 0L;
        for (Transfer t : this) {
            if (!t.isRunning()) continue;
            transferred += t.getTransferred().longValue();
        }
        return new TransferProgress(size, transferred, MessageFormat.format(LocaleFactory.localizedString("{0} of {1}"), this.sizeFormatter.format(transferred), this.sizeFormatter.format(size)), -1.0);
    }
}

