/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.spectra;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathNormalizer;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.spectra.SpectraClientBuilder;
import ch.cyberduck.core.spectra.SpectraExceptionMappingService;
import ch.cyberduck.core.spectra.SpectraSession;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.commands.GetServiceRequest;
import com.spectralogic.ds3client.commands.GetServiceResponse;
import com.spectralogic.ds3client.models.BucketDetails;
import com.spectralogic.ds3client.networking.FailedRequestException;
import java.io.IOException;
import java.util.EnumSet;
import org.jets3t.service.impl.rest.httpclient.RestStorageService;

public class SpectraBucketListService
implements ListService {
    private final SpectraSession session;

    public SpectraBucketListService(SpectraSession session) {
        this.session = session;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        try {
            AttributedList buckets = new AttributedList();
            Ds3Client client = new SpectraClientBuilder().wrap((RestStorageService)this.session.getClient(), this.session.getHost());
            GetServiceResponse response = client.getService(new GetServiceRequest());
            for (BucketDetails b : response.getListAllMyBucketsResult().getBuckets()) {
                Path bucket = new Path(PathNormalizer.normalize((String)b.getName()), EnumSet.of(AbstractPath.Type.volume, AbstractPath.Type.directory));
                bucket.attributes().setCreationDate(b.getCreationDate().getTime());
                buckets.add((Referenceable)bucket);
            }
            return buckets;
        }
        catch (FailedRequestException e) {
            throw new SpectraExceptionMappingService().map("Listing directory {0} failed", e, directory);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map("Listing directory {0} failed", (Throwable)e, directory);
        }
    }

    public ListService withCache(Cache<Path> cache) {
        return this;
    }
}

