/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.triplecrypt;

import com.dracoon.sdk.crypto.CryptoException;
import com.dracoon.sdk.crypto.FileDecryptionCipher;
import com.dracoon.sdk.crypto.model.EncryptedDataContainer;
import com.dracoon.sdk.crypto.model.PlainDataContainer;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import org.apache.commons.io.IOUtils;
import org.apache.commons.io.input.ProxyInputStream;
import org.apache.commons.lang3.ArrayUtils;

public class TripleCryptInputStream
extends ProxyInputStream {
    private final InputStream proxy;
    private final FileDecryptionCipher cipher;
    private final byte[] tag;
    private ByteBuffer buffer = ByteBuffer.allocate(0);
    private long lastread = -1L;

    public TripleCryptInputStream(InputStream proxy, FileDecryptionCipher cipher, byte[] tag) {
        super(proxy);
        this.proxy = proxy;
        this.cipher = cipher;
        this.tag = tag;
    }

    public int read() throws IOException {
        if (!this.buffer.hasRemaining()) {
            this.readNextChunk();
        }
        return this.buffer.get();
    }

    public int read(byte[] b) throws IOException {
        return this.read(b, 0, b.length);
    }

    public int read(byte[] dst, int off, int len) throws IOException {
        int remaining;
        int count;
        ByteBuffer dest = ByteBuffer.allocate(len);
        for (remaining = len; remaining > 0; remaining -= count) {
            int location = len - remaining;
            count = this.read(dest, off + location, remaining);
            if (-1 == count) {
                if (remaining != len) break;
                return -1;
            }
            dest.get(dst, off + location, count);
        }
        return len - remaining;
    }

    private int read(ByteBuffer dst, int off, int len) throws IOException {
        int read;
        if (!this.buffer.hasRemaining() && (read = this.readNextChunk()) == -1) {
            return -1;
        }
        read = Math.min(len, this.buffer.remaining());
        System.arraycopy(this.buffer.array(), this.buffer.position(), dst.array(), off, read);
        this.buffer.position(this.buffer.position() + read);
        return read;
    }

    private int readNextChunk() throws IOException {
        ByteBuffer ciphertextBuf = ByteBuffer.allocate(16);
        int read = IOUtils.read((InputStream)this.proxy, (byte[])ciphertextBuf.array());
        if (this.lastread == 0L) {
            return -1;
        }
        ciphertextBuf.position(read);
        ciphertextBuf.flip();
        try {
            PlainDataContainer pDataContainer;
            if (read == 0) {
                PlainDataContainer c1 = this.cipher.processBytes(TripleCryptInputStream.createEncryptedDataContainer(ciphertextBuf.array(), read, null));
                PlainDataContainer c2 = this.cipher.doFinal(new EncryptedDataContainer(null, this.tag));
                pDataContainer = new PlainDataContainer(ArrayUtils.addAll((byte[])c1.getContent(), (byte[])c2.getContent()));
            } else {
                pDataContainer = this.cipher.processBytes(TripleCryptInputStream.createEncryptedDataContainer(ciphertextBuf.array(), read, null));
            }
            byte[] content = pDataContainer.getContent();
            this.buffer = ByteBuffer.allocate(content.length);
            this.buffer.put(content);
            this.buffer.flip();
            this.lastread = read;
            return content.length;
        }
        catch (CryptoException e) {
            throw new IOException(e);
        }
    }

    private static EncryptedDataContainer createEncryptedDataContainer(byte[] bytes, int len, byte[] tag) {
        byte[] b = new byte[len];
        System.arraycopy(bytes, 0, b, 0, len);
        return new EncryptedDataContainer(b, tag);
    }

    public long skip(long len) throws IOException {
        return IOUtils.skip((InputStream)((Object)this), (long)len);
    }
}

