/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.CustomerData;
import ch.cyberduck.core.sds.io.swagger.client.model.RoleList;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAttributes;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAuthMethod;
import ch.cyberduck.core.sds.io.swagger.client.model.UserGroup;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.joda.time.DateTime;

public class UserAccount {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="login")
    private String login = null;
    @JsonProperty(value="needsToChangePassword")
    private Boolean needsToChangePassword = null;
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="isLocked")
    private Boolean isLocked = null;
    @JsonProperty(value="hasManageableRooms")
    private Boolean hasManageableRooms = null;
    @JsonProperty(value="userRoles")
    private RoleList userRoles = null;
    @JsonProperty(value="authMethods")
    private List<UserAuthMethod> authMethods = new ArrayList<UserAuthMethod>();
    @JsonProperty(value="customer")
    private CustomerData customer = null;
    @JsonProperty(value="lockStatus")
    private Integer lockStatus = null;
    @JsonProperty(value="needsToChangeUserName")
    private Boolean needsToChangeUserName = null;
    @JsonProperty(value="needsToAcceptEULA")
    private Boolean needsToAcceptEULA = null;
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="gender")
    private GenderEnum gender = null;
    @JsonProperty(value="expireAt")
    private DateTime expireAt = null;
    @JsonProperty(value="isEncryptionEnabled")
    private Boolean isEncryptionEnabled = null;
    @JsonProperty(value="lastLoginSuccessAt")
    private DateTime lastLoginSuccessAt = null;
    @JsonProperty(value="lastLoginFailAt")
    private DateTime lastLoginFailAt = null;
    @JsonProperty(value="userGroups")
    private List<UserGroup> userGroups = null;
    @JsonProperty(value="userAttributes")
    private UserAttributes userAttributes = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="phone")
    private String phone = null;
    @JsonProperty(value="homeRoomId")
    private Long homeRoomId = null;
    @JsonProperty(value="lastLoginSuccessIp")
    private String lastLoginSuccessIp = null;
    @JsonProperty(value="lastLoginFailIp")
    private String lastLoginFailIp = null;

    public UserAccount id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Unique identifier for the user")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UserAccount login(String login) {
        this.login = login;
        return this;
    }

    @ApiModelProperty(required=true, value="User login name")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public UserAccount needsToChangePassword(Boolean needsToChangePassword) {
        this.needsToChangePassword = needsToChangePassword;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="Determines whether user has to change his / her password")
    public Boolean isNeedsToChangePassword() {
        return this.needsToChangePassword;
    }

    public void setNeedsToChangePassword(Boolean needsToChangePassword) {
        this.needsToChangePassword = needsToChangePassword;
    }

    public UserAccount firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(required=true, value="User first name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UserAccount lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(required=true, value="User last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UserAccount isLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="User is locked: * `false` - unlocked * `true` - locked  Iser is locked and can not login anymore. (default: `false`)")
    public Boolean isIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public UserAccount hasManageableRooms(Boolean hasManageableRooms) {
        this.hasManageableRooms = hasManageableRooms;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="User has manageable rooms")
    public Boolean isHasManageableRooms() {
        return this.hasManageableRooms;
    }

    public void setHasManageableRooms(Boolean hasManageableRooms) {
        this.hasManageableRooms = hasManageableRooms;
    }

    public UserAccount userRoles(RoleList userRoles) {
        this.userRoles = userRoles;
        return this;
    }

    @ApiModelProperty(required=true, value="List of user roles")
    public RoleList getUserRoles() {
        return this.userRoles;
    }

    public void setUserRoles(RoleList userRoles) {
        this.userRoles = userRoles;
    }

    public UserAccount authMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
        return this;
    }

    public UserAccount addAuthMethodsItem(UserAuthMethod authMethodsItem) {
        this.authMethods.add(authMethodsItem);
        return this;
    }

    @ApiModelProperty(required=true, value="Authentication methods: * `sql` * `active_directory` * `radius` * `openid`")
    public List<UserAuthMethod> getAuthMethods() {
        return this.authMethods;
    }

    public void setAuthMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
    }

    public UserAccount customer(CustomerData customer) {
        this.customer = customer;
        return this;
    }

    @ApiModelProperty(required=true, value="`DEPRECATED`: Customer information Please use response from `GET /user/account/customer` instead.  [Deprecated since version 4.10.0]")
    public CustomerData getCustomer() {
        return this.customer;
    }

    public void setCustomer(CustomerData customer) {
        this.customer = customer;
    }

    public UserAccount lockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @ApiModelProperty(required=true, value="`DEPRECATED`: User lock status: * `0` - locked * `1` - Web access allowed * `2` - Web and mobile access allowed  Please use `isLocked` instead.  [Deprecated since version 4.7.0]")
    public Integer getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
    }

    public UserAccount needsToChangeUserName(Boolean needsToChangeUserName) {
        this.needsToChangeUserName = needsToChangeUserName;
        return this;
    }

    @ApiModelProperty(example="false", value="If `true`, the user must change the `userName` at the first login. (default: `false`)")
    public Boolean isNeedsToChangeUserName() {
        return this.needsToChangeUserName;
    }

    public void setNeedsToChangeUserName(Boolean needsToChangeUserName) {
        this.needsToChangeUserName = needsToChangeUserName;
    }

    public UserAccount needsToAcceptEULA(Boolean needsToAcceptEULA) {
        this.needsToAcceptEULA = needsToAcceptEULA;
        return this;
    }

    @ApiModelProperty(example="false", value="User has accepted EULA. Present, if EULA is system global active. cf. `GET config/settings` - `eula_active`")
    public Boolean isNeedsToAcceptEULA() {
        return this.needsToAcceptEULA;
    }

    public void setNeedsToAcceptEULA(Boolean needsToAcceptEULA) {
        this.needsToAcceptEULA = needsToAcceptEULA;
    }

    public UserAccount title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Job title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UserAccount gender(GenderEnum gender) {
        this.gender = gender;
        return this;
    }

    @ApiModelProperty(example="n", value="Gender")
    public GenderEnum getGender() {
        return this.gender;
    }

    public void setGender(GenderEnum gender) {
        this.gender = gender;
    }

    public UserAccount expireAt(DateTime expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    @ApiModelProperty(example="2018-01-01T00:00:00", value="Expiration date")
    public DateTime getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(DateTime expireAt) {
        this.expireAt = expireAt;
    }

    public UserAccount isEncryptionEnabled(Boolean isEncryptionEnabled) {
        this.isEncryptionEnabled = isEncryptionEnabled;
        return this;
    }

    @ApiModelProperty(example="false", value="User has generated private key. Possible if client-side encryption is active for this customer")
    public Boolean isIsEncryptionEnabled() {
        return this.isEncryptionEnabled;
    }

    public void setIsEncryptionEnabled(Boolean isEncryptionEnabled) {
        this.isEncryptionEnabled = isEncryptionEnabled;
    }

    public UserAccount lastLoginSuccessAt(DateTime lastLoginSuccessAt) {
        this.lastLoginSuccessAt = lastLoginSuccessAt;
        return this;
    }

    @ApiModelProperty(example="2018-01-01T00:00:00", value="Last successful logon date")
    public DateTime getLastLoginSuccessAt() {
        return this.lastLoginSuccessAt;
    }

    public void setLastLoginSuccessAt(DateTime lastLoginSuccessAt) {
        this.lastLoginSuccessAt = lastLoginSuccessAt;
    }

    public UserAccount lastLoginFailAt(DateTime lastLoginFailAt) {
        this.lastLoginFailAt = lastLoginFailAt;
        return this;
    }

    @ApiModelProperty(example="2018-01-01T00:00:00", value="Last failed logon date")
    public DateTime getLastLoginFailAt() {
        return this.lastLoginFailAt;
    }

    public void setLastLoginFailAt(DateTime lastLoginFailAt) {
        this.lastLoginFailAt = lastLoginFailAt;
    }

    public UserAccount userGroups(List<UserGroup> userGroups) {
        this.userGroups = userGroups;
        return this;
    }

    public UserAccount addUserGroupsItem(UserGroup userGroupsItem) {
        if (this.userGroups == null) {
            this.userGroups = new ArrayList<UserGroup>();
        }
        this.userGroups.add(userGroupsItem);
        return this;
    }

    @ApiModelProperty(value="All groups the user is member of")
    public List<UserGroup> getUserGroups() {
        return this.userGroups;
    }

    public void setUserGroups(List<UserGroup> userGroups) {
        this.userGroups = userGroups;
    }

    public UserAccount userAttributes(UserAttributes userAttributes) {
        this.userAttributes = userAttributes;
        return this;
    }

    @ApiModelProperty(value="User attributes")
    public UserAttributes getUserAttributes() {
        return this.userAttributes;
    }

    public void setUserAttributes(UserAttributes userAttributes) {
        this.userAttributes = userAttributes;
    }

    public UserAccount email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(example="john.doe@email.com", value="Email (not used)")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UserAccount phone(String phone) {
        this.phone = phone;
        return this;
    }

    @ApiModelProperty(value="Phone Number")
    public String getPhone() {
        return this.phone;
    }

    public void setPhone(String phone) {
        this.phone = phone;
    }

    public UserAccount homeRoomId(Long homeRoomId) {
        this.homeRoomId = homeRoomId;
        return this;
    }

    @ApiModelProperty(value="Homeroom ID")
    public Long getHomeRoomId() {
        return this.homeRoomId;
    }

    public void setHomeRoomId(Long homeRoomId) {
        this.homeRoomId = homeRoomId;
    }

    public UserAccount lastLoginSuccessIp(String lastLoginSuccessIp) {
        this.lastLoginSuccessIp = lastLoginSuccessIp;
        return this;
    }

    @ApiModelProperty(value="Last successful logon IP address  [Deprecated since version 4.6.0]")
    public String getLastLoginSuccessIp() {
        return this.lastLoginSuccessIp;
    }

    public void setLastLoginSuccessIp(String lastLoginSuccessIp) {
        this.lastLoginSuccessIp = lastLoginSuccessIp;
    }

    public UserAccount lastLoginFailIp(String lastLoginFailIp) {
        this.lastLoginFailIp = lastLoginFailIp;
        return this;
    }

    @ApiModelProperty(value="Last failed logon IP address  [Deprecated since version 4.6.0]")
    public String getLastLoginFailIp() {
        return this.lastLoginFailIp;
    }

    public void setLastLoginFailIp(String lastLoginFailIp) {
        this.lastLoginFailIp = lastLoginFailIp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UserAccount userAccount = (UserAccount)o;
        return Objects.equals(this.id, userAccount.id) && Objects.equals(this.login, userAccount.login) && Objects.equals(this.needsToChangePassword, userAccount.needsToChangePassword) && Objects.equals(this.firstName, userAccount.firstName) && Objects.equals(this.lastName, userAccount.lastName) && Objects.equals(this.isLocked, userAccount.isLocked) && Objects.equals(this.hasManageableRooms, userAccount.hasManageableRooms) && Objects.equals(this.userRoles, userAccount.userRoles) && Objects.equals(this.authMethods, userAccount.authMethods) && Objects.equals(this.customer, userAccount.customer) && Objects.equals(this.lockStatus, userAccount.lockStatus) && Objects.equals(this.needsToChangeUserName, userAccount.needsToChangeUserName) && Objects.equals(this.needsToAcceptEULA, userAccount.needsToAcceptEULA) && Objects.equals(this.title, userAccount.title) && Objects.equals((Object)this.gender, (Object)userAccount.gender) && Objects.equals(this.expireAt, userAccount.expireAt) && Objects.equals(this.isEncryptionEnabled, userAccount.isEncryptionEnabled) && Objects.equals(this.lastLoginSuccessAt, userAccount.lastLoginSuccessAt) && Objects.equals(this.lastLoginFailAt, userAccount.lastLoginFailAt) && Objects.equals(this.userGroups, userAccount.userGroups) && Objects.equals(this.userAttributes, userAccount.userAttributes) && Objects.equals(this.email, userAccount.email) && Objects.equals(this.phone, userAccount.phone) && Objects.equals(this.homeRoomId, userAccount.homeRoomId) && Objects.equals(this.lastLoginSuccessIp, userAccount.lastLoginSuccessIp) && Objects.equals(this.lastLoginFailIp, userAccount.lastLoginFailIp);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.id, this.login, this.needsToChangePassword, this.firstName, this.lastName, this.isLocked, this.hasManageableRooms, this.userRoles, this.authMethods, this.customer, this.lockStatus, this.needsToChangeUserName, this.needsToAcceptEULA, this.title, this.gender, this.expireAt, this.isEncryptionEnabled, this.lastLoginSuccessAt, this.lastLoginFailAt, this.userGroups, this.userAttributes, this.email, this.phone, this.homeRoomId, this.lastLoginSuccessIp, this.lastLoginFailIp});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UserAccount {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("    needsToChangePassword: ").append(this.toIndentedString(this.needsToChangePassword)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    isLocked: ").append(this.toIndentedString(this.isLocked)).append("\n");
        sb.append("    hasManageableRooms: ").append(this.toIndentedString(this.hasManageableRooms)).append("\n");
        sb.append("    userRoles: ").append(this.toIndentedString(this.userRoles)).append("\n");
        sb.append("    authMethods: ").append(this.toIndentedString(this.authMethods)).append("\n");
        sb.append("    customer: ").append(this.toIndentedString(this.customer)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("    needsToChangeUserName: ").append(this.toIndentedString(this.needsToChangeUserName)).append("\n");
        sb.append("    needsToAcceptEULA: ").append(this.toIndentedString(this.needsToAcceptEULA)).append("\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString((Object)this.gender)).append("\n");
        sb.append("    expireAt: ").append(this.toIndentedString(this.expireAt)).append("\n");
        sb.append("    isEncryptionEnabled: ").append(this.toIndentedString(this.isEncryptionEnabled)).append("\n");
        sb.append("    lastLoginSuccessAt: ").append(this.toIndentedString(this.lastLoginSuccessAt)).append("\n");
        sb.append("    lastLoginFailAt: ").append(this.toIndentedString(this.lastLoginFailAt)).append("\n");
        sb.append("    userGroups: ").append(this.toIndentedString(this.userGroups)).append("\n");
        sb.append("    userAttributes: ").append(this.toIndentedString(this.userAttributes)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    phone: ").append(this.toIndentedString(this.phone)).append("\n");
        sb.append("    homeRoomId: ").append(this.toIndentedString(this.homeRoomId)).append("\n");
        sb.append("    lastLoginSuccessIp: ").append(this.toIndentedString(this.lastLoginSuccessIp)).append("\n");
        sb.append("    lastLoginFailIp: ").append(this.toIndentedString(this.lastLoginFailIp)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GenderEnum {
        M("m"),
        F("f"),
        N("n");

        private String value;

        private GenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GenderEnum fromValue(String text) {
            for (GenderEnum b : GenderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

