/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UpdateOAuthClientRequest {
    @JsonProperty(value="clientSecret")
    private String clientSecret = null;
    @JsonProperty(value="clientName")
    private String clientName = null;
    @JsonProperty(value="isEnabled")
    private Boolean isEnabled = null;
    @JsonProperty(value="grantTypes")
    private List<String> grantTypes = null;
    @JsonProperty(value="redirectUris")
    private List<String> redirectUris = null;
    @JsonProperty(value="accessTokenValidity")
    private Integer accessTokenValidity = null;
    @JsonProperty(value="refreshTokenValidity")
    private Integer refreshTokenValidity = null;

    public UpdateOAuthClientRequest clientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
        return this;
    }

    @ApiModelProperty(value="Secret, which client uses at authentication.")
    public String getClientSecret() {
        return this.clientSecret;
    }

    public void setClientSecret(String clientSecret) {
        this.clientSecret = clientSecret;
    }

    public UpdateOAuthClientRequest clientName(String clientName) {
        this.clientName = clientName;
        return this;
    }

    @ApiModelProperty(value="Name, which is shown at the client configuration and authorization.")
    public String getClientName() {
        return this.clientName;
    }

    public void setClientName(String clientName) {
        this.clientName = clientName;
    }

    public UpdateOAuthClientRequest isEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
        return this;
    }

    @ApiModelProperty(example="true", value="Determines whether client is enabled.")
    public Boolean isIsEnabled() {
        return this.isEnabled;
    }

    public void setIsEnabled(Boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public UpdateOAuthClientRequest grantTypes(List<String> grantTypes) {
        this.grantTypes = grantTypes;
        return this;
    }

    public UpdateOAuthClientRequest addGrantTypesItem(String grantTypesItem) {
        if (this.grantTypes == null) {
            this.grantTypes = new ArrayList<String>();
        }
        this.grantTypes.add(grantTypesItem);
        return this;
    }

    @ApiModelProperty(example="[\"password\"]", value="Authorized grant types cf. [RFC 6749](https://tools.ietf.org/html/rfc6749)")
    public List<String> getGrantTypes() {
        return this.grantTypes;
    }

    public void setGrantTypes(List<String> grantTypes) {
        this.grantTypes = grantTypes;
    }

    public UpdateOAuthClientRequest redirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
        return this;
    }

    public UpdateOAuthClientRequest addRedirectUrisItem(String redirectUrisItem) {
        if (this.redirectUris == null) {
            this.redirectUris = new ArrayList<String>();
        }
        this.redirectUris.add(redirectUrisItem);
        return this;
    }

    @ApiModelProperty(value="URIs, to which a user is redirected after authorization.")
    public List<String> getRedirectUris() {
        return this.redirectUris;
    }

    public void setRedirectUris(List<String> redirectUris) {
        this.redirectUris = redirectUris;
    }

    public UpdateOAuthClientRequest accessTokenValidity(Integer accessTokenValidity) {
        this.accessTokenValidity = accessTokenValidity;
        return this;
    }

    @ApiModelProperty(value="Validity of the access token in seconds.")
    public Integer getAccessTokenValidity() {
        return this.accessTokenValidity;
    }

    public void setAccessTokenValidity(Integer accessTokenValidity) {
        this.accessTokenValidity = accessTokenValidity;
    }

    public UpdateOAuthClientRequest refreshTokenValidity(Integer refreshTokenValidity) {
        this.refreshTokenValidity = refreshTokenValidity;
        return this;
    }

    @ApiModelProperty(value="Validity of the refresh token in seconds.")
    public Integer getRefreshTokenValidity() {
        return this.refreshTokenValidity;
    }

    public void setRefreshTokenValidity(Integer refreshTokenValidity) {
        this.refreshTokenValidity = refreshTokenValidity;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateOAuthClientRequest updateOAuthClientRequest = (UpdateOAuthClientRequest)o;
        return Objects.equals(this.clientSecret, updateOAuthClientRequest.clientSecret) && Objects.equals(this.clientName, updateOAuthClientRequest.clientName) && Objects.equals(this.isEnabled, updateOAuthClientRequest.isEnabled) && Objects.equals(this.grantTypes, updateOAuthClientRequest.grantTypes) && Objects.equals(this.redirectUris, updateOAuthClientRequest.redirectUris) && Objects.equals(this.accessTokenValidity, updateOAuthClientRequest.accessTokenValidity) && Objects.equals(this.refreshTokenValidity, updateOAuthClientRequest.refreshTokenValidity);
    }

    public int hashCode() {
        return Objects.hash(this.clientSecret, this.clientName, this.isEnabled, this.grantTypes, this.redirectUris, this.accessTokenValidity, this.refreshTokenValidity);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateOAuthClientRequest {\n");
        sb.append("    clientSecret: ").append(this.toIndentedString(this.clientSecret)).append("\n");
        sb.append("    clientName: ").append(this.toIndentedString(this.clientName)).append("\n");
        sb.append("    isEnabled: ").append(this.toIndentedString(this.isEnabled)).append("\n");
        sb.append("    grantTypes: ").append(this.toIndentedString(this.grantTypes)).append("\n");
        sb.append("    redirectUris: ").append(this.toIndentedString(this.redirectUris)).append("\n");
        sb.append("    accessTokenValidity: ").append(this.toIndentedString(this.accessTokenValidity)).append("\n");
        sb.append("    refreshTokenValidity: ").append(this.toIndentedString(this.refreshTokenValidity)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

