/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.CustomerAttributes;
import ch.cyberduck.core.sds.io.swagger.client.model.FirstAdminUser;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class NewCustomerRequest {
    @JsonProperty(value="customerContractType")
    private CustomerContractTypeEnum customerContractType = null;
    @JsonProperty(value="quotaMax")
    private Long quotaMax = null;
    @JsonProperty(value="userMax")
    private Integer userMax = null;
    @JsonProperty(value="firstAdminUser")
    private FirstAdminUser firstAdminUser = null;
    @JsonProperty(value="companyName")
    private String companyName = null;
    @JsonProperty(value="trialDays")
    private Integer trialDays = null;
    @JsonProperty(value="isLocked")
    private Boolean isLocked = null;
    @JsonProperty(value="customerAttributes")
    private CustomerAttributes customerAttributes = null;
    @JsonProperty(value="lockStatus")
    private Boolean lockStatus = null;
    @JsonProperty(value="activationCode")
    private String activationCode = null;
    @JsonProperty(value="providerCustomerId")
    private String providerCustomerId = null;

    public NewCustomerRequest customerContractType(CustomerContractTypeEnum customerContractType) {
        this.customerContractType = customerContractType;
        return this;
    }

    @ApiModelProperty(example="pay", required=true, value="Customer type")
    public CustomerContractTypeEnum getCustomerContractType() {
        return this.customerContractType;
    }

    public void setCustomerContractType(CustomerContractTypeEnum customerContractType) {
        this.customerContractType = customerContractType;
    }

    public NewCustomerRequest quotaMax(Long quotaMax) {
        this.quotaMax = quotaMax;
        return this;
    }

    @ApiModelProperty(required=true, value="Maximal disc space which can be allocated by customer in bytes.")
    public Long getQuotaMax() {
        return this.quotaMax;
    }

    public void setQuotaMax(Long quotaMax) {
        this.quotaMax = quotaMax;
    }

    public NewCustomerRequest userMax(Integer userMax) {
        this.userMax = userMax;
        return this;
    }

    @ApiModelProperty(required=true, value="Maximal number of users")
    public Integer getUserMax() {
        return this.userMax;
    }

    public void setUserMax(Integer userMax) {
        this.userMax = userMax;
    }

    public NewCustomerRequest firstAdminUser(FirstAdminUser firstAdminUser) {
        this.firstAdminUser = firstAdminUser;
        return this;
    }

    @ApiModelProperty(required=true, value="First admin user of a customer")
    public FirstAdminUser getFirstAdminUser() {
        return this.firstAdminUser;
    }

    public void setFirstAdminUser(FirstAdminUser firstAdminUser) {
        this.firstAdminUser = firstAdminUser;
    }

    public NewCustomerRequest companyName(String companyName) {
        this.companyName = companyName;
        return this;
    }

    @ApiModelProperty(value="Company name")
    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public NewCustomerRequest trialDays(Integer trialDays) {
        this.trialDays = trialDays;
        return this;
    }

    @ApiModelProperty(value="Number of days left for trial period (relevant only for type `demo`)")
    public Integer getTrialDays() {
        return this.trialDays;
    }

    public void setTrialDays(Integer trialDays) {
        this.trialDays = trialDays;
    }

    public NewCustomerRequest isLocked(Boolean isLocked) {
        this.isLocked = isLocked;
        return this;
    }

    @ApiModelProperty(example="false", value="Customer is locked: * `false` - unlocked * `true` - locked  All users of this customer will be blocked and can not login anymore. (default: `false`)")
    public Boolean isIsLocked() {
        return this.isLocked;
    }

    public void setIsLocked(Boolean isLocked) {
        this.isLocked = isLocked;
    }

    public NewCustomerRequest customerAttributes(CustomerAttributes customerAttributes) {
        this.customerAttributes = customerAttributes;
        return this;
    }

    @ApiModelProperty(value="Customer attributes")
    public CustomerAttributes getCustomerAttributes() {
        return this.customerAttributes;
    }

    public void setCustomerAttributes(CustomerAttributes customerAttributes) {
        this.customerAttributes = customerAttributes;
    }

    public NewCustomerRequest lockStatus(Boolean lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @ApiModelProperty(example="false", value="`DEPRECATED`: Customer lock status: * `false` - unlocked * `true` - locked  Please use `isLocked` instead. All users of this customer will be blocked and can not login anymore. (default: `false`)")
    public Boolean isLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Boolean lockStatus) {
        this.lockStatus = lockStatus;
    }

    public NewCustomerRequest activationCode(String activationCode) {
        this.activationCode = activationCode;
        return this;
    }

    @ApiModelProperty(value="`DEPRECATED`: Customer activation code string: * valid only for types `free` and `demo` * for `pay` customers it is empty")
    public String getActivationCode() {
        return this.activationCode;
    }

    public void setActivationCode(String activationCode) {
        this.activationCode = activationCode;
    }

    public NewCustomerRequest providerCustomerId(String providerCustomerId) {
        this.providerCustomerId = providerCustomerId;
        return this;
    }

    @ApiModelProperty(value="`DEPRECATED`: Provider customer ID")
    public String getProviderCustomerId() {
        return this.providerCustomerId;
    }

    public void setProviderCustomerId(String providerCustomerId) {
        this.providerCustomerId = providerCustomerId;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        NewCustomerRequest newCustomerRequest = (NewCustomerRequest)o;
        return Objects.equals((Object)this.customerContractType, (Object)newCustomerRequest.customerContractType) && Objects.equals(this.quotaMax, newCustomerRequest.quotaMax) && Objects.equals(this.userMax, newCustomerRequest.userMax) && Objects.equals(this.firstAdminUser, newCustomerRequest.firstAdminUser) && Objects.equals(this.companyName, newCustomerRequest.companyName) && Objects.equals(this.trialDays, newCustomerRequest.trialDays) && Objects.equals(this.isLocked, newCustomerRequest.isLocked) && Objects.equals(this.customerAttributes, newCustomerRequest.customerAttributes) && Objects.equals(this.lockStatus, newCustomerRequest.lockStatus) && Objects.equals(this.activationCode, newCustomerRequest.activationCode) && Objects.equals(this.providerCustomerId, newCustomerRequest.providerCustomerId);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.customerContractType, this.quotaMax, this.userMax, this.firstAdminUser, this.companyName, this.trialDays, this.isLocked, this.customerAttributes, this.lockStatus, this.activationCode, this.providerCustomerId});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class NewCustomerRequest {\n");
        sb.append("    customerContractType: ").append(this.toIndentedString((Object)this.customerContractType)).append("\n");
        sb.append("    quotaMax: ").append(this.toIndentedString(this.quotaMax)).append("\n");
        sb.append("    userMax: ").append(this.toIndentedString(this.userMax)).append("\n");
        sb.append("    firstAdminUser: ").append(this.toIndentedString(this.firstAdminUser)).append("\n");
        sb.append("    companyName: ").append(this.toIndentedString(this.companyName)).append("\n");
        sb.append("    trialDays: ").append(this.toIndentedString(this.trialDays)).append("\n");
        sb.append("    isLocked: ").append(this.toIndentedString(this.isLocked)).append("\n");
        sb.append("    customerAttributes: ").append(this.toIndentedString(this.customerAttributes)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("    activationCode: ").append(this.toIndentedString(this.activationCode)).append("\n");
        sb.append("    providerCustomerId: ").append(this.toIndentedString(this.providerCustomerId)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum CustomerContractTypeEnum {
        FREE("free"),
        DEMO("demo"),
        PAY("pay");

        private String value;

        private CustomerContractTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static CustomerContractTypeEnum fromValue(String text) {
            for (CustomerContractTypeEnum b : CustomerContractTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

