/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;

public class LoginRequest {
    @JsonProperty(value="login")
    private String login = null;
    @JsonProperty(value="password")
    private String password = null;
    @JsonProperty(value="authType")
    private AuthTypeEnum authType = null;
    @JsonProperty(value="token")
    private String token = null;
    @JsonProperty(value="state")
    private String state = null;
    @JsonProperty(value="language")
    private String language = null;

    public LoginRequest login(String login) {
        this.login = login;
        return this;
    }

    @ApiModelProperty(required=true, value="User login name")
    public String getLogin() {
        return this.login;
    }

    public void setLogin(String login) {
        this.login = login;
    }

    public LoginRequest password(String password) {
        this.password = password;
        return this;
    }

    @ApiModelProperty(required=true, value="Password")
    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public LoginRequest authType(AuthTypeEnum authType) {
        this.authType = authType;
        return this;
    }

    @ApiModelProperty(example="sql", value="Authentication methods: * `sql` * `active_directory` * `radius`")
    public AuthTypeEnum getAuthType() {
        return this.authType;
    }

    public void setAuthType(AuthTypeEnum authType) {
        this.authType = authType;
    }

    public LoginRequest token(String token) {
        this.token = token;
        return this;
    }

    @ApiModelProperty(value="Token")
    public String getToken() {
        return this.token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public LoginRequest state(String state) {
        this.state = state;
        return this;
    }

    @ApiModelProperty(value="For RADIUS Access-Challenge If a `replyState` is returned, it must be included as `state` in the following request.")
    public String getState() {
        return this.state;
    }

    public void setState(String state) {
        this.state = state;
    }

    public LoginRequest language(String language) {
        this.language = language;
        return this;
    }

    @ApiModelProperty(example="de", value="`DEPRECATED`: Language ID or ISO 639-1 code")
    public String getLanguage() {
        return this.language;
    }

    public void setLanguage(String language) {
        this.language = language;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LoginRequest loginRequest = (LoginRequest)o;
        return Objects.equals(this.login, loginRequest.login) && Objects.equals(this.password, loginRequest.password) && Objects.equals((Object)this.authType, (Object)loginRequest.authType) && Objects.equals(this.token, loginRequest.token) && Objects.equals(this.state, loginRequest.state) && Objects.equals(this.language, loginRequest.language);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.login, this.password, this.authType, this.token, this.state, this.language});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class LoginRequest {\n");
        sb.append("    login: ").append(this.toIndentedString(this.login)).append("\n");
        sb.append("    password: ").append(this.toIndentedString(this.password)).append("\n");
        sb.append("    authType: ").append(this.toIndentedString((Object)this.authType)).append("\n");
        sb.append("    token: ").append(this.toIndentedString(this.token)).append("\n");
        sb.append("    state: ").append(this.toIndentedString(this.state)).append("\n");
        sb.append("    language: ").append(this.toIndentedString(this.language)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum AuthTypeEnum {
        SQL("sql"),
        ACTIVE_DIRECTORY("active_directory"),
        RADIUS("radius");

        private String value;

        private AuthTypeEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static AuthTypeEnum fromValue(String text) {
            for (AuthTypeEnum b : AuthTypeEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

