/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.sds.SDSAttributesFinderFeature;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPathContainerService;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.CopyNodesRequest;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;
import ch.cyberduck.core.transfer.TransferStatus;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SDSCopyFeature
implements Copy {
    private static final Logger log = Logger.getLogger(SDSCopyFeature.class);
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private final PathContainerService containerService = new SDSPathContainerService();

    public SDSCopyFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            Node node = new NodesApi((ApiClient)this.session.getClient()).copyNodes(new CopyNodesRequest().addNodeIdsItem(Long.parseLong(this.nodeid.getFileid(source, (ListProgressListener)new DisabledListProgressListener()))).resolutionStrategy(CopyNodesRequest.ResolutionStrategyEnum.OVERWRITE), Long.parseLong(this.nodeid.getFileid(target.getParent(), (ListProgressListener)new DisabledListProgressListener())), "", null);
            return new Path(target.getParent(), target.getName(), target.getType(), new SDSAttributesFinderFeature(this.session, this.nodeid).toAttributes(node));
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Cannot copy {0}", e, source);
        }
    }

    public boolean isRecursive(Path source, Path target) {
        return true;
    }

    public boolean isSupported(Path source, Path target) {
        if (this.containerService.isContainer(source)) {
            return false;
        }
        if (this.nodeid.isEncrypted(source) ^ this.nodeid.isEncrypted(target)) {
            log.warn((Object)String.format("Cannot use server side copy with source container %s and target container %s", this.containerService.getContainer(source), this.containerService.getContainer(target)));
            return false;
        }
        if (!StringUtils.equals((CharSequence)source.getName(), (CharSequence)target.getName())) {
            log.warn((Object)String.format("Deny copy of %s for changed name %s", source, target.getName()));
            return false;
        }
        if (Objects.equals(source.getParent(), target.getParent())) {
            log.warn((Object)String.format("Deny copy of %s to %s", source, target));
            return false;
        }
        return true;
    }
}

