/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dropbox;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.dropbox.DropboxExceptionMappingService;
import ch.cyberduck.core.dropbox.DropboxSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.transfer.TransferStatus;
import com.dropbox.core.DbxException;
import com.dropbox.core.v2.DbxRawClientV2;
import com.dropbox.core.v2.files.DbxUserFilesRequests;
import java.util.Map;

public class DropboxDeleteFeature
implements Delete {
    private final DropboxSession session;

    public DropboxDeleteFeature(DropboxSession session) {
        this.session = session;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        for (Path file : files.keySet()) {
            try {
                callback.delete(file);
                new DbxUserFilesRequests((DbxRawClientV2)this.session.getClient()).deleteV2(file.getAbsolute());
            }
            catch (DbxException e) {
                throw new DropboxExceptionMappingService().map("Cannot delete {0}", e, file);
            }
        }
    }

    public boolean isRecursive() {
        return true;
    }
}

