/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.b2.B2AttributesFinderFeature;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.b2.B2TouchFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import org.apache.commons.lang3.StringUtils;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2FileResponse;

public class B2CopyFeature
implements Copy {
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2FileidProvider fileid;

    public B2CopyFeature(B2Session session, B2FileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public Path copy(Path source, Path target, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        try {
            B2FileResponse response = ((B2ApiClient)this.session.getClient()).copyFile(this.fileid.getFileid(source, (ListProgressListener)new DisabledListProgressListener()), this.containerService.getKey(target));
            return new Path(target.getParent(), target.getName(), target.getType(), new B2AttributesFinderFeature(this.session, this.fileid).toAttributes(response));
        }
        catch (B2ApiException e) {
            if (StringUtils.equals((CharSequence)"file_state_none", (CharSequence)e.getMessage())) {
                return new B2TouchFeature(this.session, this.fileid).touch(target, status);
            }
            throw new B2ExceptionMappingService().map("Cannot copy {0}", e, source);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public boolean isSupported(Path source, Path target) {
        if (source.getType().contains(AbstractPath.Type.upload)) {
            return false;
        }
        return this.containerService.getContainer(source).equals((Object)this.containerService.getContainer(target));
    }

    public boolean isRecursive(Path source, Path target) {
        return false;
    }
}

