/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.b2.B2ExceptionMappingService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2PathContainerService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.PromptUrlProvider;
import java.io.IOException;
import java.net.URI;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import synapticloop.b2.B2ApiClient;
import synapticloop.b2.exception.B2ApiException;

public class B2AuthorizedUrlProvider
implements PromptUrlProvider<Void, Void> {
    private static final Logger log = Logger.getLogger(B2AuthorizedUrlProvider.class);
    private final PathContainerService containerService = new B2PathContainerService();
    private final B2Session session;
    private final B2FileidProvider fileid;

    public B2AuthorizedUrlProvider(B2Session session, B2FileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public boolean isSupported(Path file, PromptUrlProvider.Type type) {
        switch (type) {
            case download: {
                return file.isFile();
            }
        }
        return false;
    }

    public DescriptiveUrl toDownloadUrl(Path file, Void none, PasswordCallback callback) throws BackgroundException {
        String download = String.format("%s/file/%s/%s", ((B2ApiClient)this.session.getClient()).getDownloadUrl(), URIEncoder.encode((String)this.containerService.getContainer(file).getName()), URIEncoder.encode((String)this.containerService.getKey(file)));
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Create download authorization for %s", file));
            }
            int seconds = 604800;
            Calendar expiry = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            expiry.add(13, 604800);
            String token = ((B2ApiClient)this.session.getClient()).getDownloadAuthorization(this.fileid.getFileid(this.containerService.getContainer(file), (ListProgressListener)new DisabledListProgressListener()), "", Integer.valueOf(604800));
            return new DescriptiveUrl(URI.create(String.format("%s?Authorization=%s", download, token)), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getMediumFormat(expiry.getTimeInMillis())));
        }
        catch (B2ApiException e) {
            throw new B2ExceptionMappingService().map(e);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public DescriptiveUrl toUploadUrl(Path file, Void none, PasswordCallback callback) throws BackgroundException {
        throw new UnsupportedException();
    }
}

