/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.brick;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Credentials;
import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.PreferencesUseragentProvider;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.brick.BrickCredentialsConfigurator;
import ch.cyberduck.core.brick.BrickPairingSchedulerFeature;
import ch.cyberduck.core.brick.BrickTimestampFeature;
import ch.cyberduck.core.brick.BrickUrlProvider;
import ch.cyberduck.core.brick.BrickWriteFeature;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVRedirectStrategy;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.dav.DAVUploadFeature;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.exception.LoginCanceledException;
import ch.cyberduck.core.exception.LoginFailureException;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.PreferencesRedirectCallback;
import ch.cyberduck.core.http.RedirectCallback;
import ch.cyberduck.core.local.BrowserLauncherFactory;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import com.google.common.util.concurrent.Uninterruptibles;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.concurrent.CountDownLatch;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.log4j.Logger;

public class BrickSession
extends DAVSession {
    private static final Logger log = Logger.getLogger(BrickSession.class);

    public BrickSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, trust, key);
    }

    public DAVClient connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) throws BackgroundException {
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        configuration.setRedirectStrategy((RedirectStrategy)new DAVRedirectStrategy((RedirectCallback)new PreferencesRedirectCallback()));
        return new DAVClient(new HostUrlProvider().withUsername(false).get(this.host), configuration);
    }

    public void login(Proxy proxy, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        Credentials credentials = this.host.getCredentials();
        if (!credentials.isPasswordAuthentication()) {
            this.pair(this.host, (ConnectionCallback)new DisabledConnectionCallback(), cancel);
        }
        try {
            super.login(proxy, prompt, cancel);
        }
        catch (LoginFailureException e) {
            log.warn((Object)String.format("Attempt to obtain new pairing keys for response %s", new Object[]{e}));
            this.pair(this.host, (ConnectionCallback)prompt, cancel);
            super.login(proxy, prompt, cancel);
        }
    }

    public Credentials pair(Host bookmark, final ConnectionCallback prompt, CancelCallback cancel) throws BackgroundException {
        final String token = new BrickCredentialsConfigurator().configure(this.host).getToken();
        BrickPairingSchedulerFeature scheduler = new BrickPairingSchedulerFeature(this, token, bookmark, cancel);
        DisabledConnectionCallback lock = new DisabledConnectionCallback(){
            final CountDownLatch lock = new CountDownLatch(1);

            public void close(String input) {
                prompt.close(input);
                this.lock.countDown();
            }

            public void warn(Host bookmark, String title, String message, String defaultButton, String cancelButton, String preference) throws ConnectionCanceledException {
                prompt.warn(bookmark, title, message, defaultButton, cancelButton, preference);
                try {
                    if (!BrowserLauncherFactory.get().open(String.format("https://app.files.com/login_from_desktop?pairing_key=%s&platform=%s&computer=%s", token, URIEncoder.encode((String)new PreferencesUseragentProvider().get()), URIEncoder.encode((String)InetAddress.getLocalHost().getHostName())))) {
                        throw new LoginCanceledException();
                    }
                }
                catch (UnknownHostException e) {
                    throw new ConnectionCanceledException((Throwable)e);
                }
                Uninterruptibles.awaitUninterruptibly((CountDownLatch)this.lock);
            }
        };
        scheduler.repeat((PasswordCallback)lock);
        lock.warn(bookmark, String.format("%s %s", LocaleFactory.localizedString((String)"Login", (String)"Login"), bookmark.getHostname()), LocaleFactory.localizedString((String)"The desktop application session has expired or been revoked.", (String)"Brick"), LocaleFactory.localizedString((String)"Open in Web Browser"), LocaleFactory.localizedString((String)"Cancel"), null);
        scheduler.shutdown();
        cancel.verify();
        return bookmark.getCredentials();
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == Write.class) {
            return (T)((Object)new BrickWriteFeature(this));
        }
        if (type == Upload.class) {
            return (T)new DAVUploadFeature((Write)new BrickWriteFeature(this));
        }
        if (type == Timestamp.class) {
            return (T)((Object)new BrickTimestampFeature(this));
        }
        if (type == UrlProvider.class) {
            return (T)((Object)new BrickUrlProvider(this.host));
        }
        return (T)super._getFeature(type);
    }
}

