/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.storegate;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.AbstractHttpWriteFeature;
import ch.cyberduck.core.http.DelayedHttpEntityCallable;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.http.HttpResponseOutputStream;
import ch.cyberduck.core.shared.DefaultAttributesFinderFeature;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.storegate.StoregateApiClient;
import ch.cyberduck.core.storegate.StoregateExceptionMappingService;
import ch.cyberduck.core.storegate.StoregateIdProvider;
import ch.cyberduck.core.storegate.StoregateSession;
import ch.cyberduck.core.storegate.io.swagger.client.ApiException;
import ch.cyberduck.core.storegate.io.swagger.client.JSON;
import ch.cyberduck.core.storegate.io.swagger.client.model.FileMetadata;
import ch.cyberduck.core.transfer.TransferStatus;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpPut;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.AbstractHttpEntity;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.util.EntityUtils;
import org.joda.time.DateTime;

public class StoregateWriteFeature
extends AbstractHttpWriteFeature<VersionId> {
    private final StoregateSession session;
    private final StoregateIdProvider fileid;
    private final Find finder;
    private final AttributesFinder attributes;

    public StoregateWriteFeature(StoregateSession session, StoregateIdProvider nodeid) {
        this(session, nodeid, (Find)new DefaultFindFeature((Session)session), (AttributesFinder)new DefaultAttributesFinderFeature((Session)session));
    }

    public StoregateWriteFeature(StoregateSession session, StoregateIdProvider fileid, Find finder, AttributesFinder attributes) {
        super(finder, attributes);
        this.session = session;
        this.fileid = fileid;
        this.finder = finder;
        this.attributes = attributes;
    }

    public Write.Append append(Path file, Long length, Cache<Path> cache) throws BackgroundException {
        if (this.finder.withCache(cache).find(file)) {
            PathAttributes attr = this.attributes.withCache(cache).find(file);
            return new Write.Append(false, true).withSize(Long.valueOf(attr.getSize())).withChecksum(attr.getChecksum());
        }
        return Write.notfound;
    }

    public boolean temporary() {
        return false;
    }

    public boolean random() {
        return false;
    }

    public HttpResponseOutputStream<VersionId> write(final Path file, final TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        DelayedHttpEntityCallable<VersionId> command = new DelayedHttpEntityCallable<VersionId>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            private HttpResponse startUpload(Path file2, TransferStatus status2) throws BackgroundException, IOException {
                StoregateApiClient client = (StoregateApiClient)StoregateWriteFeature.this.session.getClient();
                HttpPost request = new HttpPost(String.format("%s/v4/upload/resumable", client.getBasePath()));
                FileMetadata meta = new FileMetadata();
                meta.setId("");
                meta.setAttributes(0);
                meta.setFlags(FileMetadata.FlagsEnum.NUMBER_0);
                if (status2.getLockId() != null) {
                    request.addHeader("X-Lock-Id", status2.getLockId().toString());
                }
                meta.setFileName(file2.getName());
                meta.setParentId(StoregateWriteFeature.this.fileid.getFileid(file2.getParent(), (ListProgressListener)new DisabledListProgressListener()));
                meta.setFileSize(status2.getLength());
                meta.setCreated(DateTime.now());
                if (null != status2.getTimestamp()) {
                    meta.setModified(new DateTime((Object)status2.getTimestamp()));
                }
                request.setEntity((HttpEntity)new StringEntity(new JSON().getContext(meta.getClass()).writeValueAsString((Object)meta), ContentType.create((String)"application/json", (String)StandardCharsets.UTF_8.name())));
                request.addHeader("Content-Type", "application/json; charset=UTF-8");
                CloseableHttpResponse response = client.getClient().execute((HttpUriRequest)request);
                try {
                    switch (response.getStatusLine().getStatusCode()) {
                        case 200: {
                            return response;
                        }
                        default: {
                            throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                        }
                    }
                }
                finally {
                    EntityUtils.consume((HttpEntity)response.getEntity());
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public VersionId call(AbstractHttpEntity entity) throws BackgroundException {
                try {
                    String header;
                    HttpResponse response;
                    try {
                        response = this.startUpload(file, status);
                    }
                    catch (InteroperabilityException e) {
                        if (null == status.getLockId()) {
                            throw e;
                        }
                        response = this.startUpload(file, status.withLockId(null));
                    }
                    if (!response.containsHeader("Location")) throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                    String putTarget = response.getFirstHeader("Location").getValue();
                    HttpPut put = new HttpPut(putTarget);
                    put.setEntity((HttpEntity)entity);
                    if (status.getLength() == 0L) {
                        header = "*/0";
                    } else {
                        HttpRange range = HttpRange.byLength((long)0L, (long)status.getLength());
                        header = String.format("%d-%d/%d", range.getStart(), range.getEnd(), status.getLength());
                    }
                    put.addHeader("Content-Range", String.format("bytes %s", header));
                    StoregateApiClient client = (StoregateApiClient)StoregateWriteFeature.this.session.getClient();
                    CloseableHttpResponse putResponse = client.getClient().execute((HttpUriRequest)put);
                    try {
                        switch (putResponse.getStatusLine().getStatusCode()) {
                            case 200: 
                            case 201: {
                                FileMetadata result = (FileMetadata)new JSON().getContext(FileMetadata.class).readValue((Reader)new InputStreamReader(putResponse.getEntity().getContent(), StandardCharsets.UTF_8), FileMetadata.class);
                                VersionId version = new VersionId(result.getId());
                                status.setVersion(version);
                                VersionId versionId = version;
                                return versionId;
                            }
                        }
                        throw new StoregateExceptionMappingService().map(new ApiException(response.getStatusLine().getStatusCode(), response.getStatusLine().getReasonPhrase(), Collections.emptyMap(), EntityUtils.toString((HttpEntity)response.getEntity())));
                    }
                    finally {
                        EntityUtils.consume((HttpEntity)putResponse.getEntity());
                    }
                }
                catch (IOException e) {
                    throw new HttpExceptionMappingService().map("Upload {0} failed", (Throwable)e, file);
                }
            }

            public long getContentLength() {
                return status.getLength();
            }
        };
        return this.write(file, status, (DelayedHttpEntityCallable)command);
    }
}

