/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.VersioningConfiguration;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Versioning;
import ch.cyberduck.core.s3.S3BucketListService;
import ch.cyberduck.core.s3.S3DefaultMultipartService;
import ch.cyberduck.core.s3.S3LocationFeature;
import ch.cyberduck.core.s3.S3ObjectListService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import ch.cyberduck.core.s3.S3VersionedObjectListService;
import java.util.EnumSet;
import org.apache.log4j.Logger;
import org.jets3t.service.model.MultipartUpload;

public class S3ListService
implements ListService {
    private static final Logger log = Logger.getLogger(S3ListService.class);
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();

    public S3ListService(S3Session session) {
        this.session = session;
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        AttributedList<Path> objects;
        VersioningConfiguration versioning;
        if (directory.isRoot()) {
            return new S3BucketListService(this.session, new S3LocationFeature.S3Region(this.session.getHost().getRegion())).list(directory, listener);
        }
        VersioningConfiguration versioningConfiguration = versioning = null != this.session.getFeature(Versioning.class) ? ((Versioning)this.session.getFeature(Versioning.class)).getConfiguration(this.containerService.getContainer(directory)) : VersioningConfiguration.empty();
        if (versioning.isEnabled()) {
            try {
                objects = new S3VersionedObjectListService(this.session).list(directory, listener);
            }
            catch (AccessDeniedException | InteroperabilityException e) {
                log.warn((Object)String.format("Ignore failure listing versioned objects. %s", e));
                objects = new S3ObjectListService(this.session).list(directory, listener);
            }
        } else {
            objects = new S3ObjectListService(this.session).list(directory, listener);
        }
        try {
            for (MultipartUpload upload : new S3DefaultMultipartService(this.session).find(directory)) {
                PathAttributes attributes = new PathAttributes();
                attributes.setVersionId(upload.getUploadId());
                attributes.setModificationDate(upload.getInitiatedDate().getTime());
                objects.add((Referenceable)new Path(directory, upload.getObjectKey(), EnumSet.of(AbstractPath.Type.file, AbstractPath.Type.upload), attributes));
            }
        }
        catch (AccessDeniedException | InteroperabilityException e) {
            log.warn((Object)String.format("Ignore failure listing incomplete multipart uploads. %s", e));
        }
        return objects;
    }

    public ListService withCache(Cache<Path> cache) {
        return this;
    }
}

