/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands.spectrads3;

import com.spectralogic.ds3client.commands.interfaces.AbstractRequest;
import com.spectralogic.ds3client.models.DataReplicationRuleType;
import com.spectralogic.ds3client.networking.HttpVerb;
import java.util.UUID;

public class PutAzureDataReplicationRuleSpectraS3Request
extends AbstractRequest {
    private final String dataPolicyId;
    private final String targetId;
    private final DataReplicationRuleType type;
    private long maxBlobPartSizeInBytes;
    private boolean replicateDeletes;

    public PutAzureDataReplicationRuleSpectraS3Request(UUID dataPolicyId, UUID targetId, DataReplicationRuleType type) {
        this.dataPolicyId = dataPolicyId.toString();
        this.targetId = targetId.toString();
        this.type = type;
        this.updateQueryParam("data_policy_id", dataPolicyId);
        this.updateQueryParam("target_id", targetId);
        this.updateQueryParam("type", type);
    }

    public PutAzureDataReplicationRuleSpectraS3Request(String dataPolicyId, String targetId, DataReplicationRuleType type) {
        this.dataPolicyId = dataPolicyId;
        this.targetId = targetId;
        this.type = type;
        this.updateQueryParam("data_policy_id", dataPolicyId);
        this.updateQueryParam("target_id", targetId);
        this.updateQueryParam("type", type);
    }

    public PutAzureDataReplicationRuleSpectraS3Request withMaxBlobPartSizeInBytes(long maxBlobPartSizeInBytes) {
        this.maxBlobPartSizeInBytes = maxBlobPartSizeInBytes;
        this.updateQueryParam("max_blob_part_size_in_bytes", maxBlobPartSizeInBytes);
        return this;
    }

    public PutAzureDataReplicationRuleSpectraS3Request withReplicateDeletes(boolean replicateDeletes) {
        this.replicateDeletes = replicateDeletes;
        this.updateQueryParam("replicate_deletes", replicateDeletes);
        return this;
    }

    @Override
    public HttpVerb getVerb() {
        return HttpVerb.POST;
    }

    @Override
    public String getPath() {
        return "/_rest_/azure_data_replication_rule";
    }

    public String getDataPolicyId() {
        return this.dataPolicyId;
    }

    public String getTargetId() {
        return this.targetId;
    }

    public DataReplicationRuleType getType() {
        return this.type;
    }

    public long getMaxBlobPartSizeInBytes() {
        return this.maxBlobPartSizeInBytes;
    }

    public boolean getReplicateDeletes() {
        return this.replicateDeletes;
    }
}

