/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.PasswordCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.transfer.TransferStatus;
import com.github.sardine.impl.SardineException;
import com.github.sardine.impl.handler.VoidResponseHandler;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.message.BasicHeader;

public class DAVDeleteFeature
implements Delete {
    private final DAVSession session;

    public DAVDeleteFeature(DAVSession session) {
        this.session = session;
    }

    public void delete(Map<Path, TransferStatus> files, PasswordCallback prompt, Delete.Callback callback) throws BackgroundException {
        ArrayList<Path> deleted = new ArrayList<Path>();
        for (Map.Entry<Path, TransferStatus> file : files.entrySet()) {
            boolean skip = false;
            for (Path d : deleted) {
                if (!file.getKey().isChild(d)) continue;
                skip = true;
                break;
            }
            if (skip) continue;
            deleted.add(file.getKey());
            callback.delete(file.getKey());
            try {
                HttpDelete delete = new HttpDelete(new DAVPathEncoder().encode(file.getKey()));
                if (file.getValue().getLockId() != null) {
                    delete.addHeader((Header)new BasicHeader("If", String.format("(<%s>)", file.getValue().getLockId())));
                }
                ((DAVClient)((Object)this.session.getClient())).execute((HttpRequestBase)delete, new VoidResponseHandler());
            }
            catch (SardineException e) {
                throw new DAVExceptionMappingService().map("Cannot delete {0}", e, file.getKey());
            }
            catch (IOException e) {
                throw new HttpExceptionMappingService().map(e, file.getKey());
            }
        }
    }

    public boolean isRecursive() {
        return true;
    }
}

