/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.DescriptiveUrl;
import ch.cyberduck.core.DescriptiveUrlBag;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.UserDateFormatterFactory;
import ch.cyberduck.core.WebUrlProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.openstack.SwiftRegionService;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.shared.DefaultUrlProvider;
import ch.iterate.openstack.swift.model.AccountInfo;
import ch.iterate.openstack.swift.model.Region;
import java.net.URI;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.text.MessageFormat;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.TimeUnit;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SwiftUrlProvider
implements UrlProvider {
    private static final Logger log = Logger.getLogger(SwiftUrlProvider.class);
    private final PathContainerService containerService = new PathContainerService();
    private final SwiftSession session;
    private final SwiftRegionService regionService;
    private final Map<Region, AccountInfo> accounts;

    public SwiftUrlProvider(SwiftSession session) {
        this(session, Collections.emptyMap());
    }

    public SwiftUrlProvider(SwiftSession session, Map<Region, AccountInfo> accounts) {
        this(session, accounts, new SwiftRegionService(session));
    }

    public SwiftUrlProvider(SwiftSession session, Map<Region, AccountInfo> accounts, SwiftRegionService regionService) {
        this.session = session;
        this.accounts = accounts;
        this.regionService = regionService;
    }

    public DescriptiveUrlBag toUrl(Path file) {
        DescriptiveUrlBag list = new DescriptiveUrlBag();
        if (file.isFile()) {
            Region region = null;
            try {
                region = this.regionService.lookup(file);
            }
            catch (BackgroundException e) {
                log.warn((Object)String.format("Failure looking up region for %s %s", file, e.getMessage()));
            }
            if (null == region) {
                list.addAll((Collection)new DefaultUrlProvider(this.session.getHost()).toUrl(file));
            } else {
                list.addAll((Collection)new WebUrlProvider(this.session.getHost()).toUrl(file));
                list.add(new DescriptiveUrl(URI.create(region.getStorageUrl(this.containerService.getContainer(file).getName(), this.containerService.getKey(file)).toString()), DescriptiveUrl.Type.provider, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), this.session.getHost().getProtocol().getScheme().name().toUpperCase(Locale.ROOT))));
                list.addAll((Collection)this.sign(region, file, this.getExpiry((int)TimeUnit.HOURS.toSeconds(1L))));
                list.addAll((Collection)this.sign(region, file, this.getExpiry((int)TimeUnit.SECONDS.toSeconds(PreferencesFactory.get().getInteger("s3.url.expire.seconds")))));
                list.addAll((Collection)this.sign(region, file, this.getExpiry((int)TimeUnit.DAYS.toSeconds(7L))));
                list.addAll((Collection)this.sign(region, file, this.getExpiry((int)TimeUnit.DAYS.toSeconds(30L))));
                list.addAll((Collection)this.sign(region, file, this.getExpiry((int)TimeUnit.DAYS.toSeconds(365L))));
            }
        }
        return list;
    }

    protected DescriptiveUrlBag sign(Region region, Path file, long expiry) {
        if (!this.accounts.containsKey(region)) {
            log.warn((Object)String.format("No account info for region %s available required to sign temporary URL", region));
            return DescriptiveUrlBag.empty();
        }
        AccountInfo info = this.accounts.get(region);
        if (StringUtils.isBlank((CharSequence)info.getTempUrlKey())) {
            log.warn((Object)"Missing X-Account-Meta-Temp-URL-Key header value to sign temporary URL");
            return DescriptiveUrlBag.empty();
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Using X-Account-Meta-Temp-URL-Key header value %s to sign", info.getTempUrlKey()));
        }
        String signature = this.sign(info.getTempUrlKey(), String.format("GET\n%d\n%s", expiry, String.format("%s/%s/%s", region.getStorageUrl().getRawPath(), URIEncoder.encode((String)this.containerService.getContainer(file).getName()), this.containerService.getKey(file))));
        DescriptiveUrlBag list = new DescriptiveUrlBag();
        for (Scheme scheme : Collections.singletonList(Scheme.valueOf((String)region.getStorageUrl().getScheme()))) {
            int port = region.getStorageUrl().getPort();
            list.add(new DescriptiveUrl(URI.create(String.format("%s://%s%s%s?temp_url_sig=%s&temp_url_expires=%d", scheme.name(), region.getStorageUrl().getHost(), port == -1 ? "" : (port == scheme.getPort() ? "" : String.format(":%d", port)), region.getStorageUrl(this.containerService.getContainer(file).getName(), this.containerService.getKey(file)).getRawPath(), signature, expiry)), DescriptiveUrl.Type.signed, MessageFormat.format(LocaleFactory.localizedString((String)"{0} URL"), LocaleFactory.localizedString((String)"Pre-Signed", (String)"S3")) + " (" + MessageFormat.format(LocaleFactory.localizedString((String)"Expires {0}", (String)"S3") + ")", UserDateFormatterFactory.get().getShortFormat(expiry * 1000L))));
        }
        return list;
    }

    protected String sign(String secret, String body) {
        try {
            SecretKeySpec signingKey = new SecretKeySpec(secret.getBytes(StandardCharsets.UTF_8), "HmacSHA1");
            Mac mac = Mac.getInstance("HmacSHA1");
            mac.init(signingKey);
            return Hex.encodeHexString((byte[])mac.doFinal(body.getBytes(StandardCharsets.UTF_8)));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException e) {
            log.error((Object)String.format("Error signing %s %s", body, e.getMessage()));
            return null;
        }
    }

    protected long getExpiry(int seconds) {
        Calendar expiry = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
        expiry.add(13, seconds);
        return expiry.getTimeInMillis() / 1000L;
    }
}

